<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package quarty
 */

?>

<?php

/* post content */
$image = get_the_post_thumbnail_url( get_the_ID(), 'quarty_950xAuto' );
$title = get_the_title();
$href = get_the_permalink();

$theme_lightbox = get_field( 'portfolio_lightbox_disable', 'option' );

?>

<div class="qrt-work-item qrt-work-open">
    <?php if ( $image ) : ?>
    <a<?php if ( ! $theme_lightbox ) : ?> data-magnific-gallery-portfolio-carousel<?php endif; ?> data-no-swup data-elementor-lightbox-slideshow="gallery" data-elementor-lightbox-title="<?php echo esc_attr( $title ); ?>" href="<?php echo esc_url( $image ); ?>" class="qrt-cursor-scale qrt-work-cover-frame">
      <img src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr( $title ); ?>">
      <div class="qrt-item-zoom qrt-cursor-color"><i class="fas fa-expand"></i></div>
    </a>
    <?php endif; ?>

    <div class="qrt-work-descr">
      <?php if ( $title ) : ?>
      <h4 class="qrt-cursor-color qrt-white"><a href="<?php echo esc_url( $href ); ?>"><?php echo esc_html( $title ); ?></a></h4>
      <?php endif; ?>
      <a href="<?php echo esc_url( $href ); ?>" class="qrt-cursor-scale qrt-work-more qrt-anima-link"><i class="fas fa-arrow-right"></i></a>
    </div>
</div>