<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
 
/**
 * Quarty Clients Widget.
 *
 * @since 1.0
 */
class Quarty_Clients_Widget extends Widget_Base {

	public function get_name() {
		return 'quarty-clients';
	}

	public function get_title() {
		return esc_html__( 'Clients', 'quarty-plugin' );
	}

	public function get_icon() {
		return 'eicon-parallax';
	}

	public function get_categories() {
		return [ 'quarty-category' ];
	}

	/**
	 * Register widget controls.
	 *
	 * @since 1.0
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'items_tab',
			[
				'label' => esc_html__( 'Items', 'quarty-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'image', [
				'label' => esc_html__( 'Image', 'quarty-plugin' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
			]
		);

		$repeater->add_control(
			'name', [
				'label'       => esc_html__( 'Name', 'quarty-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter name', 'quarty-plugin' ),
				'default'	=> esc_html__( 'Enter name', 'quarty-plugin' ),
			]
		);

		$repeater->add_control(
			'link', [
				'label' => esc_html__( 'URL', 'quarty-plugin' ),
				'type' => Controls_Manager::URL,
				'show_external' => true,
			]
		);

		$this->add_control(
			'items',
			[
				'label' => esc_html__( 'Clients Items', 'quarty-plugin' ),
				'type' => Controls_Manager::REPEATER,
				'prevent_empty' => false,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ name }}}',
			]
		);

		$this->end_controls_section();
	}


	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		?>

		<div class="qrt-section">
		<?php if ( $settings['items'] ) : ?>
		<div class="row">
          <div class="col-lg-12">

            <div class="swiper-container qrt-brands-slider" style="overflow: visible">
              <div class="swiper-wrapper">
                <?php foreach ( $settings['items'] as $index => $item ) : ?>
                <?php if ( $item['image'] ) : $image = wp_get_attachment_image_url( $item['image']['id'], 'quarty_256x256' ); ?>
                <div class="swiper-slide">
                  <?php if ( $item['link'] ) : ?>
				  <a <?php if ( $item['link']['is_external'] ) : ?> target="_blank"<?php endif; ?><?php if ( $item['link']['nofollow'] ) : ?> rel="nofollow"<?php endif; ?> href="<?php echo esc_url( $item['link']['url'] ); ?>">
				  <?php endif; ?>
                  <img src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr( $item['name'] ); ?>">
                  <?php if ( $item['link'] ) : ?>
				  </a>
				  <?php endif; ?>
                </div>
                <?php endif; ?>
                <?php endforeach; ?>
              </div>
            </div>

          </div>
        </div>
        <?php endif; ?>
    	</div>

		<?php
	}

	/**
	 * Render widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function content_template() {
		?>

		<div class="qrt-section">
		<# if ( settings.items ) { #>
		<div class="row">
          <div class="col-lg-12">

            <div class="swiper-container qrt-brands-slider" style="overflow: visible">
              <div class="swiper-wrapper">
                <# _.each( settings.items, function( item, index ) { #>
                <# if ( item.image ) { #>
                <div class="swiper-slide">
                  <# if ( item.link ) { #>
				  <a <# if ( item.link.is_external ) { #> target="_blank"<# } #><# if ( item.link.nofollow ) { #> rel="nofollow"<# } #> href="{{{ item.link.url }}}">
				  <# } #>
                  <img src="{{{ item.image.url }}}" alt="{{{ item.name }}}">
                  <# if ( item.link ) { #>
				  </a>
				  <# } #>
                </div>
                <# } #>
                <# }); #>
              </div>
            </div>

          </div>
        </div>
        <# } #>
    	</div>
    	
		<?php 
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Quarty_Clients_Widget() );