<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
 
/**
 * Quarty Pricing Widget.
 *
 * @since 1.0
 */
class Quarty_Pricing_Widget extends Widget_Base {

	public function get_name() {
		return 'quarty-pricing';
	}

	public function get_title() {
		return esc_html__( 'Pricing', 'quarty-plugin' );
	}

	public function get_icon() {
		return 'eicon-parallax';
	}

	public function get_categories() {
		return [ 'quarty-category' ];
	}

	/**
	 * Register widget controls.
	 *
	 * @since 1.0
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'title_tab',
			[
				'label' => esc_html__( 'Title', 'quarty-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'title',
			[
				'label'       => esc_html__( 'Title', 'quarty-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter title', 'quarty-plugin' ),
				'default'     => esc_html__( 'Title', 'quarty-plugin' ),
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'       => esc_html__( 'Title Tag', 'quarty-plugin' ),
				'type'        => Controls_Manager::SELECT,
				'default' => 'h3',
				'options' => [
					'h1'  => __( 'H1', 'quarty-plugin' ),
					'h2' => __( 'H2', 'quarty-plugin' ),
					'h3' => __( 'H3', 'quarty-plugin' ),
					'h4' => __( 'H4', 'quarty-plugin' ),
					'div' => __( 'DIV', 'quarty-plugin' ),
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'items_tab',
			[
				'label' => esc_html__( 'Items', 'quarty-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'name', [
				'label'       => esc_html__( 'Title', 'quarty-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter title', 'quarty-plugin' ),
				'default'	=> esc_html__( 'Enter title', 'quarty-plugin' ),
			]
		);

		$repeater->add_control(
			'price', [
				'label'       => esc_html__( 'Price', 'quarty-plugin' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'placeholder' => 100,
				'default'	=> 100,
			]
		);

		$repeater->add_control(
			'price_before', [
				'label'       => esc_html__( 'Price (before)', 'quarty-plugin' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( '$', 'quarty-plugin' ),
				'default'	=> esc_html__( '$', 'quarty-plugin' ),
			]
		);

		$repeater->add_control(
			'price_after', [
				'label'       => esc_html__( 'Price (after)', 'quarty-plugin' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'hour', 'quarty-plugin' ),
				'default'	=> esc_html__( 'hour', 'quarty-plugin' ),
			]
		);

		$repeater->add_control(
			'price_note', [
				'label'       => esc_html__( 'Price Note (*)', 'quarty-plugin' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Price Note', 'quarty-plugin' ),
				'default'	=> '',
			]
		);

		$repeater->add_control(
			'list', [
				'label'       => esc_html__( 'List', 'quarty-plugin' ),
				'type' => Controls_Manager::WYSIWYG,
				'placeholder' => esc_html__( 'List', 'quarty-plugin' ),
				'default'	=> '',
			]
		);

		$repeater->add_control(
			'button', [
				'label'       => esc_html__( 'Button (title)', 'quarty-plugin' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Button Label', 'quarty-plugin' ),
				'default'	=> esc_html__( 'Order Now', 'quarty-plugin' ),
			]
		);

		$repeater->add_control(
			'link', [
				'label'       => esc_html__( 'Button (link)', 'quarty-plugin' ),
				'type' => Controls_Manager::URL,
				'show_external' => true,
			]
		);

		$repeater->add_control(
			'badge', [
				'label'       => esc_html__( 'Popular Badge', 'quarty-plugin' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'quarty-plugin' ),
				'label_off' => __( 'Hide', 'quarty-plugin' ),
				'return_value' => 'yes',
				'default' => 'no',
			]
		);

		$this->add_control(
			'items',
			[
				'label' => esc_html__( 'Pricing Items', 'quarty-plugin' ),
				'type' => Controls_Manager::REPEATER,
				'prevent_empty' => false,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ name }}}',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'title_styling',
			[
				'label'     => esc_html__( 'Title', 'quarty-plugin' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-section .qrt-title-h' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typography',
				'selector' => '{{WRAPPER}} .qrt-section .qrt-title-h',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'items_styling',
			[
				'label'     => esc_html__( 'Items', 'quarty-plugin' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'item_name_color',
			[
				'label'     => esc_html__( 'Title Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-price .qrt-price-body h5' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'label'     => esc_html__( 'Title Typography', 'quarty-plugin' ),
				'name'     => 'item_name_typography',
				'selector' => '{{WRAPPER}} .qrt-price .qrt-price-body h5',
			]
		);

		$this->add_control(
			'item_price_color',
			[
				
				'label'     => esc_html__( 'Price Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-price .qrt-price-body .qrt-price-cost .qrt-number' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'item_price_typography',
				'label'     => esc_html__( 'Price Typography', 'quarty-plugin' ),
				'selector' => '{{WRAPPER}} .qrt-price .qrt-price-body .qrt-price-cost .qrt-number',
			]
		);

		$this->add_control(
			'item_price2_color',
			[
				
				'label'     => esc_html__( 'Price Secondary Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-price .qrt-price-body .qrt-price-cost .qrt-number .qrt-number-span' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'item_price2_typography',
				'label'     => esc_html__( 'Price Secondary Typography', 'quarty-plugin' ),
				'selector' => '{{WRAPPER}} .qrt-price .qrt-price-body .qrt-price-cost .qrt-number .qrt-number-span',
			]
		);

		$this->add_control(
			'item_list_color',
			[
				
				'label'     => esc_html__( 'List Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-price .qrt-price-body .qrt-price-list' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'item_list_typography',
				'label'     => esc_html__( 'List Typography', 'quarty-plugin' ),
				'selector' => '{{WRAPPER}} .qrt-price .qrt-price-body .qrt-price-list',
			]
		);

		$this->add_control(
			'item_button_color',
			[
				
				'label'     => esc_html__( 'Button Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-price .qrt-price-body .qrt-btn' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'item_button_typography',
				'label'     => esc_html__( 'Button Typography', 'quarty-plugin' ),
				'selector' => '{{WRAPPER}} .qrt-price .qrt-price-body .qrt-btn',
			]
		);

		$this->add_control(
			'item_badge_color',
			[
				
				'label'     => esc_html__( 'Popular Badge Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-price.qrt-popular-price:before' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'item_badge_bg_color',
			[
				
				'label'     => esc_html__( 'Popular Badge Background', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-price.qrt-popular-price:before' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'item_badge_typography',
				'label'     => esc_html__( 'Popular Badge Typography', 'quarty-plugin' ),
				'selector' => '{{WRAPPER}} .qrt-price.qrt-popular-price:before',
			]
		);

		$this->end_controls_section();
	}


	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		$this->add_inline_editing_attributes( 'title', 'basic' );
		
		?>

		<div class="qrt-section qrt-section-sf">
			<div class="row">
              <?php if ( $settings['title'] ) : ?>
              <div class="col-lg-12">
                <<?php echo esc_attr( $settings['title_tag'] ); ?> class="qrt-title-h qrt-mb-40">
            		<span <?php echo $this->get_render_attribute_string( 'title' ); ?>>
		          		<?php echo wp_kses_post( $settings['title'] ); ?>
		         	</span>
            	</<?php echo esc_attr( $settings['title_tag'] ); ?>>
              </div>
              <?php endif; ?>

              <?php if ( $settings['items'] ) : ?>
			  <?php foreach ( $settings['items'] as $index => $item ) : 
			  $item_name = $this->get_repeater_setting_key( 'name', 'items', $index );
			  $this->add_inline_editing_attributes( $item_name, 'basic' );

			  $item_price = $this->get_repeater_setting_key( 'price', 'items', $index );
			  $this->add_inline_editing_attributes( $item_price, 'none' );

			  $item_price_before = $this->get_repeater_setting_key( 'price_before', 'items', $index );
			  $this->add_inline_editing_attributes( $item_price_before, 'none' );

			  $item_price_after = $this->get_repeater_setting_key( 'price_after', 'items', $index );
		 	  $this->add_inline_editing_attributes( $item_price_after, 'none' );
		 	  
		 	  $item_price_note = $this->get_repeater_setting_key( 'price_note', 'items', $index );
		 	  $this->add_inline_editing_attributes( $item_price_note, 'basic' );

		 	  $item_list = $this->get_repeater_setting_key( 'list', 'items', $index );
			  $this->add_inline_editing_attributes( $item_list, 'advanced' );

			  $item_button = $this->get_repeater_setting_key( 'button', 'items', $index );
			  $this->add_inline_editing_attributes( $item_button, 'none' );
			  ?>
              <div class="<?php if ( get_field( 'page_layout' ) != 1 ) : ?>col-lg-3<?php else : ?>col-lg-4<?php endif; ?>">
                <div class="qrt-a qrt-price<?php if ( $item['badge'] == 'yes' ) : ?> qrt-popular-price<?php endif; ?>">
                  <div class="qrt-price-body">
                    <?php if ( $item['name'] ) : ?>
                    <h5 class="qrt-mb-20">
                    	<span <?php echo $this->get_render_attribute_string( $item_name ); ?>>
							<?php echo wp_kses_post( $item['name'] ); ?>
						</span>
                    </h5>
                    <?php endif; ?>
                    <?php if ( $item['price'] ) : ?>
                    <div class="qrt-price-cost">
                      <div class="qrt-number">
                      	<?php if ( $item['price_before'] ) : ?>
                      	<span class="qrt-number-span">
                      		<span <?php echo $this->get_render_attribute_string( $item_price_before ); ?>>
								<?php echo esc_html( $item['price_before'] ); ?>
							</span>
						</span>
						<?php endif; ?>
						<span <?php echo $this->get_render_attribute_string( $item_price ); ?>>
							<?php echo esc_html( $item['price'] ); ?>
						</span>
                      	<?php if ( $item['price_after'] ) : ?>
                      	<span class="qrt-number-span">
                      		<span <?php echo $this->get_render_attribute_string( $item_price_after ); ?>>
								<?php echo esc_html( $item['price_after'] ); ?>
							</span>
						</span>
                      	<?php endif; ?>
                      	<?php if ( $item['price_note'] ) : ?>
		          		<sup><?php echo esc_html__('*', 'quarty-plugin' ); ?></sup>
		          		<?php endif; ?>
                      </div>
                    </div>
                    <?php endif; ?>
                    <?php if ( $item['list'] ) : ?>
                    <div class="qrt-price-list">
                      <div <?php echo $this->get_render_attribute_string( $item_list ); ?>>
						<?php echo wp_kses_post( $item['list'] ); ?>
					  </div>
                    </div>
                    <?php endif; ?>
                    <?php if ( $item['button'] ) : ?>
                    <a<?php if ( $item['link'] ) : if ( $item['link']['is_external'] ) : ?> target="_blank"<?php endif; ?><?php if ( $item['link']['nofollow'] ) : ?> rel="nofollow"<?php endif; ?> href="<?php echo esc_url( $item['link']['url'] ); ?>"<?php endif; ?> class="qrt-btn qrt-btn-md<?php if ( $item['badge'] == 'yes' ) : ?> qrt-btn-color<?php endif; ?> qrt-cursor-scale qrt-anima-link">
                    	<span <?php echo $this->get_render_attribute_string( $item_button ); ?>>
							<?php echo esc_html( $item['button'] ); ?>
						</span>
                    	<i class="fas fa-arrow-right"></i>
                    </a>
                    <?php endif; ?>
                    <?php if ( $item['price_note'] ) : ?>
                    <div class="qrt-asterisk">
                    	<sup><?php echo esc_html__('*', 'quarty-plugin' ); ?></sup>
                    	<span <?php echo $this->get_render_attribute_string( $item_price_note ); ?>>
							<?php echo wp_kses_post( $item['price_note'] ); ?>
						</span>
                    </div>
                    <?php endif; ?>
                  </div>
                </div>
              </div>
              <?php endforeach; ?>
		  	  <?php endif; ?>

            </div>
        </div>

		<?php
	}

	/**
	 * Render widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function content_template() {
		?>
		<#
		view.addInlineEditingAttributes( 'title', 'basic' );
		#>

		<div class="qrt-section qrt-section-sf">
			<div class="row">
              <# if ( settings.title ) { #>
              <div class="col-lg-12">
                <{{{ settings.title_tag }}} class="qrt-title-h qrt-mb-40">
            		<span {{{ view.getRenderAttributeString( 'title' ) }}}>
		          		{{{ settings.title }}}
		         	</span>
            	</{{{ settings.title_tag }}}>
              </div>
              <# } #>

              <# if ( settings.items ) { #>
			  <# _.each( settings.items, function( item, index ) {

			    var item_name = view.getRepeaterSettingKey( 'name', 'items', index );
			    view.addInlineEditingAttributes( item_name, 'basic' );

			    var item_price = view.getRepeaterSettingKey( 'price', 'items', index );
			    view.addInlineEditingAttributes( item_price, 'none' );

			    var item_price_before = view.getRepeaterSettingKey( 'price_before', 'items', index );
			    view.addInlineEditingAttributes( item_price_before, 'none' );

			    var item_price_after = view.getRepeaterSettingKey( 'price_after', 'items', index );
			    view.addInlineEditingAttributes( item_price_after, 'none' );

			    var item_price_note = view.getRepeaterSettingKey( 'price_note', 'items', index );
			    view.addInlineEditingAttributes( item_price_note, 'basic' );

			    var item_list = view.getRepeaterSettingKey( 'list', 'items', index );
			    view.addInlineEditingAttributes( item_list, 'advanced' );

			    var item_button = view.getRepeaterSettingKey( 'button', 'items', index );
			    view.addInlineEditingAttributes( item_button, 'none' );

			  #>
              <div class="col-lg-3">
                <div class="qrt-a qrt-price<# if ( item.badge == 'yes' ) { #> qrt-popular-price<# } #>">
                  <div class="qrt-price-body">
                    <# if ( item.name ) { #>
                    <h5 class="qrt-mb-20">
                    	<span {{{ view.getRenderAttributeString( item_name ) }}}>
							{{{ item.name }}}
						</span>
                    </h5>
                    <# } #>
                    <# if ( item.price ) { #>
                    <div class="qrt-price-cost">
                      <div class="qrt-number">
                      	<# if ( item.price_before ) { #>
                      	<span class="qrt-number-span">
                      		<span {{{ view.getRenderAttributeString( item_price_before ) }}}>
								{{{ item.price_before }}}
							</span>
						</span>
						<# } #>
						<span {{{ view.getRenderAttributeString( item_price ) }}}>
							{{{ item.price }}}
						</span>
                      	<# if ( item.price_after ) { #>
                      	<span class="qrt-number-span">
                      		<span {{{ view.getRenderAttributeString( item_price_after ) }}}>
								{{{ item.price_after }}}
							</span>
						</span>
                      	<# } #>
                      	<# if ( item.price_note ) { #>
		          		<sup>*</sup>
		          		<# } #>
                      </div>
                    </div>
                    <# } #>
                    <# if ( item.list ) { #>
                    <div class="qrt-price-list">
                      <div {{{ view.getRenderAttributeString( item_list ) }}}>
						{{{ item.list }}}
					  </div>
                    </div>
                    <# } #>
                    <# if ( item.button ) { #>
                    <a<# if ( item.link ) { #><# if ( item.link.is_external ) { #> target="_blank"<# } #><# if ( item.link.nofollow ) { #> rel="nofollow"<# } #> href="{{{ item.link.url }}}"<# } #> class="qrt-btn qrt-btn-md<# if ( item.badge == 'yes' ) { #> qrt-btn-color<# } #> qrt-cursor-scale qrt-anima-link">
                    	<span {{{ view.getRenderAttributeString( item_button ) }}}>
							{{{ item.button }}}
						</span>
                    	<i class="fas fa-arrow-right"></i>
                    </a>
                    <# } #>
                    <# if ( item.price_note ) { #>
                    <div class="qrt-asterisk">
                    	<sup>*</sup>
                    	<span {{{ view.getRenderAttributeString( item_price_note ) }}}>
							{{{ item.price_note }}}
						</span>
                    </div>
                    <# } #>
                  </div>
                </div>
              </div>
              <# }); #>
		  	  <# } #>

            </div>
        </div>

		<?php 
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Quarty_Pricing_Widget() );