<?php
/**
 * The default template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage WEALTHCO
 * @since WEALTHCO 1.0
 */

$wealthco_post_format = get_post_format();
$wealthco_post_format = empty( $wealthco_post_format ) ? 'standard' : str_replace( 'post-format-', '', $wealthco_post_format );
$wealthco_animation   = wealthco_get_theme_option( 'blog_animation' );

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_excerpt post_format_' . esc_attr( $wealthco_post_format ) ); ?>
	<?php echo ( ! wealthco_is_off( $wealthco_animation ) ? ' data-animation="' . esc_attr( wealthco_get_animation_classes( $wealthco_animation ) ) . '"' : '' ); ?>
	>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<div class="post_sticky_wrap">
		<?php
	}

	// Featured image
	wealthco_show_post_featured(
		array(
			'go'         => true,
			'thumb_size' => wealthco_get_thumb_size( strpos( wealthco_get_theme_option( 'body_style' ), 'full' ) !== false ? 'full' : 'big' ),
		)
	);

	// Title and post meta
	if ( get_the_title() != '' ) {
		?>
		<div class="post_header entry-header">
			<?php
			// Post meta
			$wealthco_components = wealthco_array_get_keys_by_value( wealthco_get_theme_option( 'meta_parts' ) );
			$wealthco_counters   = wealthco_array_get_keys_by_value( wealthco_get_theme_option( 'counters' ) );
			?>
			<div class="meta-wrap"><?php
			if ( ! empty( $wealthco_components ) ) {
				wealthco_show_post_meta(
					apply_filters(
						'wealthco_filter_post_meta_args', array(
							'components' => $wealthco_components,
							'counters'   => '',
							'seo'        => false,
						), 'excerpt', 1
					)
				);
			}
			?><div class="right"><?php
			if ( ! empty( $wealthco_components ) ) {
				if ( stristr( $wealthco_components, 'counters' ) != '' ) {
					$wealthco_components = 'counters';
					wealthco_show_post_meta(
						apply_filters(
							'wealthco_filter_post_meta_args', array(
								'components' => $wealthco_components,
								'counters'   => $wealthco_counters,
								'seo'        => false,
							), 'excerpt', 1
						)
					);
				}
			}

			?></div></div><?php

			do_action( 'wealthco_action_before_post_title' );

			// Post title
			the_title( sprintf( '<h2 class="post_title entry-title"><a href="%s" rel="bookmark">', esc_url( get_permalink() ) ), '</a></h2>' );

			do_action( 'wealthco_action_before_post_meta' );


			?>
		</div><!-- .post_header -->
		<?php
	}

	// Post content
	?>
	<div class="post_content entry-content">
	<?php
	if ( wealthco_get_theme_option( 'blog_content' ) == 'fullpost' ) {
		// Post content area
		?>
			<div class="post_content_inner">
			<?php
			the_content( '' );
			?>
			</div>
			<?php
			// Inner pages
			wp_link_pages(
				array(
					'before'      => '<div class="page_links"><span class="page_links_title">' . esc_html__( 'Pages:', 'wealthco' ) . '</span>',
					'after'       => '</div>',
					'link_before' => '<span>',
					'link_after'  => '</span>',
					'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'wealthco' ) . ' </span>%',
					'separator'   => '<span class="screen-reader-text">, </span>',
				)
			);

	} else {

		$wealthco_show_learn_more = ! in_array( $wealthco_post_format, array( 'link', 'aside', 'status' ) ) && ! is_sticky();

		// Post content area
		?>
			<div class="post_content_inner">
			<?php
			if ( has_excerpt() ) {
				the_excerpt();
			} elseif ( strpos( get_the_content( '!--more' ), '!--more' ) !== false ) {
				the_content( '' );
			} elseif ( in_array( $wealthco_post_format, array( 'link', 'aside', 'status' ) ) ) {
				the_content();
			} elseif ( $wealthco_post_format == 'quote' ) {
				if ( ( $quote = wealthco_get_tag( get_the_content(), '<blockquote>', '</blockquote>' ) ) != '' ) {
					wealthco_show_layout( wpautop( $quote ) );
				} else {
					the_excerpt();
				}
			} elseif ( substr( get_the_content(), 0, 4 ) != '[vc_' ) {
				the_excerpt();
			}
			?>
			</div>
			<?php
			// More button
			if ( $wealthco_show_learn_more ) {
				?>
				<p><a class="more-link" href="<?php echo esc_url( get_permalink() ); ?>"><?php esc_html_e( 'continue', 'wealthco' ); ?></a></p>
				<?php
			}

			$wealthco_components = wealthco_array_get_keys_by_value( wealthco_get_theme_option( 'meta_parts' ) );
			if ( ! empty( $wealthco_components ) ) {
				wealthco_show_post_meta(
					apply_filters(
						'wealthco_filter_post_meta_args', array(
							'components' => $wealthco_components,
							'counters'   => '',
							'seo'        => false,
						), 'excerpt', 1
					)
				);
			}
	}
	?>
	</div><!-- .entry-content -->

		<?php
		if ( is_sticky() && ! is_paged() ) {
			?>
			</div>
			<?php
		}
		?>


</article>
