<?php
/**
 * The Portfolio template to display the content
 *
 * Used for index/archive/search.
 *
 * @package WordPress
 * @subpackage WEALTHCO
 * @since WEALTHCO 1.0
 */

$wealthco_blog_style  = explode( '_', wealthco_get_theme_option( 'blog_style' ) );
$wealthco_columns     = empty( $wealthco_blog_style[1] ) ? 2 : max( 2, $wealthco_blog_style[1] );
$wealthco_post_format = get_post_format();
$wealthco_post_format = empty( $wealthco_post_format ) ? 'standard' : str_replace( 'post-format-', '', $wealthco_post_format );
$wealthco_animation   = wealthco_get_theme_option( 'blog_animation' );

?><article id="post-<?php the_ID(); ?>" 
	<?php post_class( 'post_item post_layout_portfolio post_layout_portfolio_' . esc_attr( $wealthco_columns ) . ' post_format_' . esc_attr( $wealthco_post_format ) . ( is_sticky() && ! is_paged() ? ' sticky' : '' ) ); ?>
	<?php echo ( ! wealthco_is_off( $wealthco_animation ) ? ' data-animation="' . esc_attr( wealthco_get_animation_classes( $wealthco_animation ) ) . '"' : '' ); ?>>
	<?php

	// Sticky label
	if ( is_sticky() && ! is_paged() ) {
		?>
		<span class="post_label label_sticky"></span>
		<?php
	}

	$wealthco_image_hover = wealthco_get_theme_option( 'image_hover' );
	// Featured image
	wealthco_show_post_featured(
		array(
			'thumb_size'    => wealthco_get_thumb_size(
				strpos( wealthco_get_theme_option( 'body_style' ), 'full' ) !== false || $wealthco_columns < 3
								? 'masonry-big'
				: 'masonry'
			),
			'show_no_image' => true,
			'class'         => $wealthco_image_hover == 'dots' || $wealthco_image_hover == 'link' ? 'hover_with_info' : '',
			'post_info'     => $wealthco_image_hover == 'dots' || $wealthco_image_hover == 'link' ? '<div class="post_info">' . esc_html( get_the_title() ) . '</div>' : '',
		)
	);
	?>
</article>
