<?php
/* Contact Form 7 support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'wealthco_cf7_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'wealthco_cf7_theme_setup9', 9 );
	function wealthco_cf7_theme_setup9() {

		add_filter( 'wealthco_filter_merge_scripts', 'wealthco_cf7_merge_scripts' );
		add_filter( 'wealthco_filter_merge_styles', 'wealthco_cf7_merge_styles' );

		if ( wealthco_exists_cf7() ) {
			add_action( 'wp_enqueue_scripts', 'wealthco_cf7_frontend_scripts', 1100 );
		}

		if ( is_admin() ) {
			add_filter( 'wealthco_filter_tgmpa_required_plugins', 'wealthco_cf7_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'wealthco_cf7_tgmpa_required_plugins' ) ) {
	//Handler of the add_filter('wealthco_filter_tgmpa_required_plugins',	'wealthco_cf7_tgmpa_required_plugins');
	function wealthco_cf7_tgmpa_required_plugins( $list = array() ) {
		if ( wealthco_storage_isset( 'required_plugins', 'contact-form-7' ) ) {
			// CF7 plugin
			$list[] = array(
				'name'     => wealthco_storage_get_array( 'required_plugins', 'contact-form-7' ),
				'slug'     => 'contact-form-7',
				'required' => false,
			);
		}
		return $list;
	}
}



// Check if cf7 installed and activated
if ( ! function_exists( 'wealthco_exists_cf7' ) ) {
	function wealthco_exists_cf7() {
		return class_exists( 'WPCF7' );
	}
}

// Enqueue custom scripts
if ( ! function_exists( 'wealthco_cf7_frontend_scripts' ) ) {
	//Handler of the add_action( 'wp_enqueue_scripts', 'wealthco_cf7_frontend_scripts', 1100 );
	function wealthco_cf7_frontend_scripts() {
		if ( wealthco_exists_cf7() ) {
			if ( wealthco_is_on( wealthco_get_theme_option( 'debug_mode' ) ) && wealthco_get_file_dir( 'plugins/contact-form-7/contact-form-7.js' ) != '' ) {
				wp_enqueue_script( 'wealthco-cf7', wealthco_get_file_url( 'plugins/contact-form-7/contact-form-7.js' ), array( 'jquery' ), null, true );
			}
		}
	}
}

// Merge custom scripts
if ( ! function_exists( 'wealthco_cf7_merge_scripts' ) ) {
	//Handler of the add_filter('wealthco_filter_merge_scripts', 'wealthco_cf7_merge_scripts');
	function wealthco_cf7_merge_scripts( $list ) {
		if ( wealthco_exists_cf7() ) {
			$list[] = 'plugins/contact-form-7/contact-form-7.js';
		}
		return $list;
	}
}

// Merge custom styles
if ( ! function_exists( 'wealthco_cf7_merge_styles' ) ) {
	//Handler of the add_filter('wealthco_filter_merge_styles', 'wealthco_cf7_merge_styles');
	function wealthco_cf7_merge_styles( $list ) {
		if ( wealthco_exists_cf7() ) {
			$list[] = 'plugins/contact-form-7/_contact-form-7.scss';
		}
		return $list;
	}
}

