<?php
/* Essential Grid support functions
------------------------------------------------------------------------------- */


// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'wealthco_essential_grid_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'wealthco_essential_grid_theme_setup9', 9 );
	function wealthco_essential_grid_theme_setup9() {

		add_filter( 'wealthco_filter_merge_styles', 'wealthco_essential_grid_merge_styles' );

		if ( is_admin() ) {
			add_filter( 'wealthco_filter_tgmpa_required_plugins', 'wealthco_essential_grid_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'wealthco_essential_grid_tgmpa_required_plugins' ) ) {
	//Handler of the add_filter('wealthco_filter_tgmpa_required_plugins',	'wealthco_essential_grid_tgmpa_required_plugins');
	function wealthco_essential_grid_tgmpa_required_plugins( $list = array() ) {
		if ( wealthco_storage_isset( 'required_plugins', 'essential-grid' ) ) {
			$path = wealthco_get_file_dir( 'plugins/essential-grid/essential-grid.zip' );
			if ( ! empty( $path ) || wealthco_get_theme_setting( 'tgmpa_upload' ) ) {
				$list[] = array(
					'name'     => wealthco_storage_get_array( 'required_plugins', 'essential-grid' ),
					'slug'     => 'essential-grid',
					'source'   => ! empty( $path ) ? $path : 'upload://essential-grid.zip',
					'required' => false,
				);
			}
		}
		return $list;
	}
}

// Check if plugin installed and activated
if ( ! function_exists( 'wealthco_exists_essential_grid' ) ) {
	function wealthco_exists_essential_grid() {
		return defined( 'EG_PLUGIN_PATH' );
	}
}

// Merge custom styles
if ( ! function_exists( 'wealthco_essential_grid_merge_styles' ) ) {
	//Handler of the add_filter('wealthco_filter_merge_styles', 'wealthco_essential_grid_merge_styles');
	function wealthco_essential_grid_merge_styles( $list ) {
		if ( wealthco_exists_essential_grid() ) {
			$list[] = 'plugins/essential-grid/_essential-grid.scss';
		}
		return $list;
	}
}

