<?php
/* Revolution Slider support functions
------------------------------------------------------------------------------- */

// Theme init priorities:
// 9 - register other filters (for installer, etc.)
if ( ! function_exists( 'wealthco_revslider_theme_setup9' ) ) {
	add_action( 'after_setup_theme', 'wealthco_revslider_theme_setup9', 9 );
	function wealthco_revslider_theme_setup9() {

		add_filter( 'wealthco_filter_merge_styles', 'wealthco_revslider_merge_styles' );

		if ( is_admin() ) {
			add_filter( 'wealthco_filter_tgmpa_required_plugins', 'wealthco_revslider_tgmpa_required_plugins' );
		}
	}
}

// Filter to add in the required plugins list
if ( ! function_exists( 'wealthco_revslider_tgmpa_required_plugins' ) ) {
	//Handler of the add_filter('wealthco_filter_tgmpa_required_plugins',	'wealthco_revslider_tgmpa_required_plugins');
	function wealthco_revslider_tgmpa_required_plugins( $list = array() ) {
		if ( wealthco_storage_isset( 'required_plugins', 'revslider' ) ) {
			$path = wealthco_get_file_dir( 'plugins/revslider/revslider.zip' );
			if ( ! empty( $path ) || wealthco_get_theme_setting( 'tgmpa_upload' ) ) {
				$list[] = array(
					'name'     => wealthco_storage_get_array( 'required_plugins', 'revslider' ),
					'slug'     => 'revslider',
					'source'   => ! empty( $path ) ? $path : 'upload://revslider.zip',
					'required' => false,
				);
			}
		}
		return $list;
	}
}

// Check if RevSlider installed and activated
if ( ! function_exists( 'wealthco_exists_revslider' ) ) {
	function wealthco_exists_revslider() {
		return function_exists( 'rev_slider_shortcode' );
	}
}

// Merge custom styles
if ( ! function_exists( 'wealthco_revslider_merge_styles' ) ) {
	//Handler of the add_filter('wealthco_filter_merge_styles', 'wealthco_revslider_merge_styles');
	function wealthco_revslider_merge_styles( $list ) {
		if ( wealthco_exists_revslider() ) {
			$list[] = 'plugins/revslider/_revslider.scss';
		}
		return $list;
	}
}

