<?php
/**
 * The template to display the Author bio
 *
 * @package WordPress
 * @subpackage WEALTHCO
 * @since WEALTHCO 1.0
 */
?>

<div class="author_info author vcard" itemprop="author" itemscope itemtype="http://schema.org/Person">
	<div class="author_info_wrap">
	<div class="author_avatar" itemprop="image">
		<?php
		$wealthco_mult = wealthco_get_retina_multiplier();
		echo get_avatar( get_the_author_meta( 'user_email' ), 150 * $wealthco_mult );
		?>
	</div><!-- .author_avatar -->

	<div class="author_description">
		<span class="label_info"><?php esc_html_e( 'About the Author', 'wealthco' ); ?></span>
		<h5 class="author_title" itemprop="name">
			<a class="author_link" href="<?php echo esc_url( get_author_posts_url( get_the_author_meta( 'ID' ) ) ); ?>" rel="author">
													<?php
													echo esc_html( get_the_author() );
													?>
			</a>
		</h5>

		<div class="author_bio" itemprop="description">
			<?php echo wp_kses_post( wpautop( get_the_author_meta( 'description' ) ) ); ?>
			<?php do_action( 'wealthco_action_user_meta' ); ?>
		</div><!-- .author_bio -->

	</div><!-- .author_description -->

	</div>

</div><!-- .author_info -->
