<?php
/**
 * The template to display the copyright info in the footer
 *
 * @package WordPress
 * @subpackage WEALTHCO
 * @since WEALTHCO 1.0.10
 */

// Copyright area
?> 
<div class="footer_copyright_wrap
<?php
if ( ! wealthco_is_inherit( wealthco_get_theme_option( 'copyright_scheme' ) ) ) {
	echo ' scheme_' . esc_attr( wealthco_get_theme_option( 'copyright_scheme' ) );
}
?>
				">
	<div class="footer_copyright_inner">
		<div class="content_wrap">
			<div class="copyright_text">
			<?php
				$wealthco_copyright = wealthco_get_theme_option( 'copyright' );
			if ( ! empty( $wealthco_copyright ) ) {
				// Replace {{Y}} or {Y} with the current year
				$wealthco_copyright = str_replace( array( '{{Y}}', '{Y}' ), date( 'Y' ), $wealthco_copyright );
				// Replace {{...}} and ((...)) on the <i>...</i> and <b>...</b>
				$wealthco_copyright = wealthco_prepare_macros( $wealthco_copyright );
				// Display copyright
				echo wp_kses_post( nl2br( $wealthco_copyright ) );
			}
			?>
			</div>
		</div>
	</div>
</div>
