<?php
/**
 * The template to display default site footer
 *
 * @package WordPress
 * @subpackage WEALTHCO
 * @since WEALTHCO 1.0.10
 */

$wealthco_footer_id = str_replace( 'footer-custom-', '', wealthco_get_theme_option( 'footer_style' ) );
if ( (int) $wealthco_footer_id == 0 ) {
	$wealthco_footer_id = wealthco_get_post_id(
		array(
			'name'      => $wealthco_footer_id,
			'post_type' => defined( 'TRX_ADDONS_CPT_LAYOUTS_PT' ) ? TRX_ADDONS_CPT_LAYOUTS_PT : 'cpt_layouts',
		)
	);
} else {
	$wealthco_footer_id = apply_filters( 'wealthco_filter_get_translated_layout', $wealthco_footer_id );
}
$wealthco_footer_meta = get_post_meta( $wealthco_footer_id, 'trx_addons_options', true );
if ( ! empty( $wealthco_footer_meta['margin'] ) != '' ) {
	wealthco_add_inline_css( sprintf( '.page_content_wrap{padding-bottom:%s}', esc_attr( wealthco_prepare_css_value( $wealthco_footer_meta['margin'] ) ) ) );
}
?>
<footer class="footer_wrap footer_custom footer_custom_
<?php
echo esc_attr( $wealthco_footer_id );
?>
						 footer_custom_
							<?php
							echo esc_attr( sanitize_title( get_the_title( $wealthco_footer_id ) ) );
							if ( ! wealthco_is_inherit( wealthco_get_theme_option( 'footer_scheme' ) ) ) {
								echo ' scheme_' . esc_attr( wealthco_get_theme_option( 'footer_scheme' ) );
							}
							?>
						">
	<?php
	// Custom footer's layout
	do_action( 'wealthco_action_show_layout', $wealthco_footer_id );
	?>
</footer><!-- /.footer_wrap -->
