<?php
/**
 * The template to display the site logo in the footer
 *
 * @package WordPress
 * @subpackage WEALTHCO
 * @since WEALTHCO 1.0.10
 */

// Logo
if ( wealthco_is_on( wealthco_get_theme_option( 'logo_in_footer' ) ) ) {
	$wealthco_logo_image = wealthco_get_logo_image( 'footer' );
	$wealthco_logo_text  = get_bloginfo( 'name' );
	if ( ! empty( $wealthco_logo_image ) || ! empty( $wealthco_logo_text ) ) {
		?>
		<div class="footer_logo_wrap">
			<div class="footer_logo_inner">
				<?php
				if ( ! empty( $wealthco_logo_image ) ) {
					$title_alt     = esc_html__( 'logo image', 'wealthco' );
					$wealthco_attr = wealthco_getimagesize( $wealthco_logo_image );
					echo '<a href="' . esc_url( home_url( '/' ) ) . '"><img src="' . esc_url( $wealthco_logo_image ) . '" class="logo_footer_image" alt="' . esc_attr( $title_alt ) . '"' . ( ! empty( $wealthco_attr[3] ) ? ' ' . wp_kses_data( $wealthco_attr[3] ) : '' ) . '></a>';
				} elseif ( ! empty( $wealthco_logo_text ) ) {
					echo '<h1 class="logo_footer_text"><a href="' . esc_url( home_url( '/' ) ) . '">' . esc_html( $wealthco_logo_text ) . '</a></h1>';
				}
				?>
			</div>
		</div>
		<?php
	}
}
?>
