<?php
/**
 * The template to display the widgets area in the footer
 *
 * @package WordPress
 * @subpackage WEALTHCO
 * @since WEALTHCO 1.0.10
 */

// Footer sidebar
$wealthco_footer_name    = wealthco_get_theme_option( 'footer_widgets' );
$wealthco_footer_present = ! wealthco_is_off( $wealthco_footer_name ) && is_active_sidebar( $wealthco_footer_name );
if ( $wealthco_footer_present ) {
	wealthco_storage_set( 'current_sidebar', 'footer' );
	$wealthco_footer_wide = wealthco_get_theme_option( 'footer_wide' );
	ob_start();
	if ( is_active_sidebar( $wealthco_footer_name ) ) {
		dynamic_sidebar( $wealthco_footer_name );
	}
	$wealthco_out = trim( ob_get_contents() );
	ob_end_clean();
	if ( ! empty( $wealthco_out ) ) {
		$wealthco_out          = preg_replace( "/<\\/aside>[\r\n\s]*<aside/", '</aside><aside', $wealthco_out );
		$wealthco_need_columns = true;  //or check: strpos($wealthco_out, 'columns_wrap')===false;
		if ( $wealthco_need_columns ) {
			$wealthco_columns = max( 0, (int) wealthco_get_theme_option( 'footer_columns' ) );
			if ( $wealthco_columns == 0 ) {
				$wealthco_columns = min( 4, max( 1, substr_count( $wealthco_out, '<aside ' ) ) );
			}
			if ( $wealthco_columns > 1 ) {
				$wealthco_out = preg_replace( '/<aside([^>]*)class="widget/', '<aside$1class="column-1_' . esc_attr( $wealthco_columns ) . ' widget', $wealthco_out );
			} else {
				$wealthco_need_columns = false;
			}
		}
		?>
		<div class="footer_widgets_wrap widget_area<?php echo ! empty( $wealthco_footer_wide ) ? ' footer_fullwidth' : ''; ?> sc_layouts_row sc_layouts_row_type_normal">
			<div class="footer_widgets_inner widget_area_inner"><?php
				if ( ! $wealthco_footer_wide ) {
					?><div class="content_wrap"><?php
				}
				if ( $wealthco_need_columns ) {
					?><div class="columns_wrap"><?php
				}
				do_action( 'wealthco_action_before_sidebar' );
				wealthco_show_layout( $wealthco_out );
				do_action( 'wealthco_action_after_sidebar' );
				if ( $wealthco_need_columns ) {
					?></div><!-- /.columns_wrap --><?php
				}
				if ( ! $wealthco_footer_wide ) {
					?></div><!-- /.content_wrap --><?php
				}
				?></div><!-- /.footer_widgets_inner --></div><!-- /.footer_widgets_wrap -->
		<?php
	}
}
?>
