<?php
/**
 * The template to display custom header from the ThemeREX Addons Layouts
 *
 * @package WordPress
 * @subpackage WEALTHCO
 * @since WEALTHCO 1.0.06
 */

$wealthco_header_css   = '';
$wealthco_header_image = get_header_image();
$wealthco_header_video = wealthco_get_header_video();
if ( ! empty( $wealthco_header_image ) && wealthco_trx_addons_featured_image_override( is_singular() || wealthco_storage_isset( 'blog_archive' ) || is_category() ) ) {
	$wealthco_header_image = wealthco_get_current_mode_image( $wealthco_header_image );
}

$wealthco_header_id = str_replace( 'header-custom-', '', wealthco_get_theme_option( 'header_style' ) );
if ( (int) $wealthco_header_id == 0 ) {
	$wealthco_header_id = wealthco_get_post_id(
		array(
			'name'      => $wealthco_header_id,
			'post_type' => defined( 'TRX_ADDONS_CPT_LAYOUTS_PT' ) ? TRX_ADDONS_CPT_LAYOUTS_PT : 'cpt_layouts',
		)
	);
} else {
	$wealthco_header_id = apply_filters( 'wealthco_filter_get_translated_layout', $wealthco_header_id );
}
$wealthco_header_meta = get_post_meta( $wealthco_header_id, 'trx_addons_options', true );
if ( ! empty( $wealthco_header_meta['margin'] ) != '' ) {
	wealthco_add_inline_css( sprintf( '.page_content_wrap{padding-top:%s}', esc_attr( wealthco_prepare_css_value( $wealthco_header_meta['margin'] ) ) ) );
}

?><header class="top_panel top_panel_custom top_panel_custom_
<?php
echo esc_attr( $wealthco_header_id );
?>
				 top_panel_custom_
					<?php
					echo esc_attr( sanitize_title( get_the_title( $wealthco_header_id ) ) );
					echo ! empty( $wealthco_header_image ) || ! empty( $wealthco_header_video )
					? ' with_bg_image'
					: ' without_bg_image';
					if ( $wealthco_header_video != '' ) {
						echo ' with_bg_video';
					}
					if ( $wealthco_header_image != '' ) {
						echo ' ' . esc_attr( wealthco_add_inline_css_class( 'background-image: url(' . esc_url( $wealthco_header_image ) . ');' ) );
					}
					if ( is_single() && has_post_thumbnail() ) {
						echo ' with_featured_image';
					}
					if ( wealthco_is_on( wealthco_get_theme_option( 'header_fullheight' ) ) ) {
						echo ' header_fullheight wealthco-full-height';
					}
					if ( ! wealthco_is_inherit( wealthco_get_theme_option( 'header_scheme' ) ) ) {
						echo ' scheme_' . esc_attr( wealthco_get_theme_option( 'header_scheme' ) );
					}
					?>
				">
				<?php

				// Background video
				if ( ! empty( $wealthco_header_video ) ) {
					get_template_part( 'templates/header-video' );
				}

				// Custom header's layout
				do_action( 'wealthco_action_show_layout', $wealthco_header_id );

				// Header widgets area
				get_template_part( 'templates/header-widgets' );

				?>
</header>
