<?php
/**
 * The template to display the page title and breadcrumbs
 *
 * @package WordPress
 * @subpackage WEALTHCO
 * @since WEALTHCO 1.0
 */

// Page (category, tag, archive, author) title

if ( wealthco_need_page_title() ) {
	wealthco_sc_layouts_showed( 'title', true );
	wealthco_sc_layouts_showed( 'postmeta', false );
	?>
	<div class="top_panel_title sc_layouts_row sc_layouts_row_type_normal scheme_dark">
		<div class="content_wrap">
			<div class="sc_layouts_column sc_layouts_column_align_left">
				<div class="sc_layouts_item">
					<div class="sc_layouts_title sc_align_left">
						<?php
						// Post meta on the single post
						if ( false && is_single() ) {
							?>
							<div class="sc_layouts_title_meta">
							<?php
								wealthco_show_post_meta(
									apply_filters(
										'wealthco_filter_post_meta_args', array(
											'components' => wealthco_array_get_keys_by_value( wealthco_get_theme_option( 'meta_parts' ) ),
											'counters'   => wealthco_array_get_keys_by_value( wealthco_get_theme_option( 'counters' ) ),
											'seo'        => wealthco_is_on( wealthco_get_theme_option( 'seo_snippets' ) ),
										), 'header', 1
									)
								);
							?>
							</div>
							<?php
						}

						// Blog/Post title
						?>
						<div class="sc_layouts_title_title">
						<?php
							$wealthco_blog_title      = wealthco_get_blog_title();
							$wealthco_blog_title_text = $wealthco_blog_title_class = $wealthco_blog_title_link = $wealthco_blog_title_link_text = '';
						if ( is_array( $wealthco_blog_title ) ) {
							$wealthco_blog_title_text      = $wealthco_blog_title['text'];
							$wealthco_blog_title_class     = ! empty( $wealthco_blog_title['class'] ) ? ' ' . $wealthco_blog_title['class'] : '';
							$wealthco_blog_title_link      = ! empty( $wealthco_blog_title['link'] ) ? $wealthco_blog_title['link'] : '';
							$wealthco_blog_title_link_text = ! empty( $wealthco_blog_title['link_text'] ) ? $wealthco_blog_title['link_text'] : '';
						} else {
							$wealthco_blog_title_text = $wealthco_blog_title;
						}
						?>
							<h1 itemprop="headline" class="sc_layouts_title_caption<?php echo esc_attr( $wealthco_blog_title_class ); ?>">
																							  <?php
																								$wealthco_top_icon = wealthco_get_category_icon();
																								if ( ! empty( $wealthco_top_icon ) ) {
																									$wealthco_attr = wealthco_getimagesize( $wealthco_top_icon );
																									$title_alt     = esc_html__( 'title', 'wealthco' );
																									?>
									<img src="<?php echo esc_url( $wealthco_top_icon ); ?>" alt="<?php echo esc_attr( $title_alt ); ?>" 
																									<?php
																									if ( ! empty( $wealthco_attr[3] ) ) {
																										wealthco_show_layout( $wealthco_attr[3] );
																									}
																									?>
									>
																										<?php
																								}
																								echo wp_kses_data( $wealthco_blog_title_text );
																								?>
							</h1>
							<?php
							if ( ! empty( $wealthco_blog_title_link ) && ! empty( $wealthco_blog_title_link_text ) ) {
								?>
								<a href="<?php echo esc_url( $wealthco_blog_title_link ); ?>" class="theme_button theme_button_small sc_layouts_title_link"><?php echo esc_html( $wealthco_blog_title_link_text ); ?></a>
								<?php
							}

							// Category/Tag description
							if ( is_category() || is_tag() || is_tax() ) {
								the_archive_description( '<div class="sc_layouts_title_description">', '</div>' );
							}

							?>
						</div>
						<?php

						if ( wealthco_exists_trx_addons() ) {
							// Breadcrumbs
							?>
							<div class="sc_layouts_title_breadcrumbs">
							<?php
								do_action( 'wealthco_action_breadcrumbs' );
							?>
							</div>
												<?php } ?>
					</div>
				</div>
			</div>
		</div>
	</div>
	<?php
}
?>
