<?php
/**
 * The template to display the background video in the header
 *
 * @package WordPress
 * @subpackage WEALTHCO
 * @since WEALTHCO 1.0.14
 */
$wealthco_header_video = wealthco_get_header_video();
$wealthco_embed_video  = '';
if ( ! empty( $wealthco_header_video ) && ! wealthco_is_from_uploads( $wealthco_header_video ) ) {
	if ( wealthco_is_youtube_url( $wealthco_header_video ) && preg_match( '/[=\/]([^=\/]*)$/', $wealthco_header_video, $matches ) && ! empty( $matches[1] ) ) {
		?><div id="background_video" data-youtube-code="<?php echo esc_attr( $matches[1] ); ?>"></div>
		<?php
	} else {
		global $wp_embed;
		if ( false && is_object( $wp_embed ) ) {
			$wealthco_embed_video = do_shortcode( $wp_embed->run_shortcode( '[embed]' . trim( $wealthco_header_video ) . '[/embed]' ) );
			$wealthco_embed_video = wealthco_make_video_autoplay( $wealthco_embed_video );
		} else {
			$wealthco_header_video = str_replace( '/watch?v=', '/embed/', $wealthco_header_video );
			$wealthco_header_video = wealthco_add_to_url(
				$wealthco_header_video, array(
					'feature'        => 'oembed',
					'controls'       => 0,
					'autoplay'       => 1,
					'showinfo'       => 0,
					'modestbranding' => 1,
					'wmode'          => 'transparent',
					'enablejsapi'    => 1,
					'origin'         => home_url(),
					'widgetid'       => 1,
				)
			);
			$wealthco_embed_video  = '<iframe src="' . esc_url( $wealthco_header_video ) . '" width="1170" height="658" allowfullscreen="0" frameborder="0"></iframe>';
		}
		?>
		<div id="background_video"><?php wealthco_show_layout( $wealthco_embed_video ); ?></div><?php
	}
}
?>
