<?php
/**
 * The template 'Style 2' to displaying related posts
 *
 * @package WordPress
 * @subpackage WEALTHCO
 * @since WEALTHCO 1.0
 */

$wealthco_link        = get_permalink();
$wealthco_post_format = get_post_format();
$wealthco_post_format = empty( $wealthco_post_format ) ? 'standard' : str_replace( 'post-format-', '', $wealthco_post_format );
?><div id="post-<?php the_ID(); ?>" 
	<?php post_class( 'related_item related_item_style_2 post_format_' . esc_attr( $wealthco_post_format ) ); ?>>
						<?php
						wealthco_show_post_featured(
							array(
								'thumb_size'    => apply_filters( 'wealthco_filter_related_thumb_size', wealthco_get_thumb_size( (int) wealthco_get_theme_option( 'related_posts' ) == 1 ? 'huge' : 'big' ) ),
								'show_no_image' => wealthco_get_theme_setting( 'allow_no_image' ),
								'singular'      => false,
							)
						);
						?>
	<div class="post_header entry-header">
		<h6 class="post_title entry-title"><a href="<?php echo esc_url( $wealthco_link ); ?>"><?php the_title(); ?></a></h6>
		<div class="post_meta">
		<?php
		if ( in_array( get_post_type(), array( 'post', 'attachment' ) ) ) {
			$author_id = get_the_author_meta( 'ID' );
			if ( empty( $author_id ) && ! empty( $GLOBALS['post']->post_author ) ) {
				$author_id = $GLOBALS['post']->post_author;
			}
			if ( $author_id > 0 ) {
				$author_link = get_author_posts_url( $author_id );
				$author_name = get_the_author_meta( 'display_name', $author_id );
				?>
				<a class="post_meta_item post_author" rel="author" href="<?php echo esc_url( $author_link ); ?>">
					<span><?php esc_html_e( 'by ', 'wealthco' ); ?></span><?php echo esc_html( $author_name ); ?>
				</a>
				<?php
			}
			?>
			<span class="post_date"><?php echo wp_kses_data( wealthco_get_date() ); ?></span>
			<?php
		}
		?>
		</div>
	</div>
</div>
