<?php
/**
 * The template 'Style 1' to displaying related posts
 *
 * @package WordPress
 * @subpackage WEALTHCO
 * @since WEALTHCO 1.0
 */

$wealthco_link        = get_permalink();
$wealthco_post_format = get_post_format();
$wealthco_post_format = empty( $wealthco_post_format ) ? 'standard' : str_replace( 'post-format-', '', $wealthco_post_format );
?><div id="post-<?php the_ID(); ?>" 
	<?php post_class( 'related_item related_item_style_1 post_format_' . esc_attr( $wealthco_post_format ) ); ?>>
						<?php
						wealthco_show_post_featured(
							array(
								'thumb_size'    => apply_filters( 'wealthco_filter_related_thumb_size', wealthco_get_thumb_size( (int) wealthco_get_theme_option( 'related_posts' ) == 1 ? 'huge' : 'big' ) ),
								'show_no_image' => wealthco_get_theme_setting( 'allow_no_image' ),
								'singular'      => false,
								'post_info'     => '<div class="post_header entry-header">'
											. '<div class="post_categories">' . wp_kses_post( wealthco_get_post_categories( '' ) ) . '</div>'
											. '<h6 class="post_title entry-title"><a href="' . esc_url( $wealthco_link ) . '">' . esc_html( get_the_title() ) . '</a></h6>'
											. ( in_array( get_post_type(), array( 'post', 'attachment' ) )
													? '<span class="post_date"><a href="' . esc_url( $wealthco_link ) . '">' . wp_kses_data( wealthco_get_date() ) . '</a></span>'
													: '' )
										. '</div>',
							)
						);
						?>
	</div>
