<?php
/**
 * Plugin Name: Apus Qxygen
 * Plugin URI: http://apusthemes.com/apus-qxygen/
 * Description: Powerful plugin to create a apartment on your website.
 * Version: 1.0.0
 * Author: Habq
 * Author URI: http://apusthemes.com/
 * Requires at least: 3.8
 * Tested up to: 5.2
 *
 * Text Domain: apus-qxygen
 * Domain Path: /languages/
 *
 * @package apus-qxygen
 * @category Plugins
 * @author Habq
 */
if ( ! defined( 'ABSPATH' ) ) {
  	exit;
}

if ( !class_exists("Apus_Qxygen") ) {
	
	final class Apus_Qxygen {

		private static $instance;

		public static function getInstance() {
			if ( ! isset( self::$instance ) && ! ( self::$instance instanceof Apus_Qxygen ) ) {
				self::$instance = new Apus_Qxygen;
				self::$instance->setup_constants();
				self::$instance->load_textdomain();

				self::$instance->includes();
			}

			return self::$instance;
		}
		/**
		 *
		 */
		public function setup_constants(){
			define( 'APUS_QXYGEN_PLUGIN_VERSION', '1.0.0' );

			define( 'APUS_QXYGEN_PLUGIN_DIR', plugin_dir_path( __FILE__ ) );
			define( 'APUS_QXYGEN_PLUGIN_URL', plugin_dir_url( __FILE__ ) );
			define( 'APUS_QXYGEN_PREFIX', 'apartment_' );
		}

		public function includes() {
			// post type
			require_once APUS_QXYGEN_PLUGIN_DIR . 'includes/post-types/class-post-type-apartment.php';

			//
			require_once APUS_QXYGEN_PLUGIN_DIR . 'includes/class-template-loader.php';
			require_once APUS_QXYGEN_PLUGIN_DIR . 'includes/class-mixes.php';
		}

		/**
		 *
		 */
		public function load_textdomain() {
			// Set filter for Apus_Qxygen's languages directory
			$lang_dir = APUS_QXYGEN_PLUGIN_DIR . 'languages/';
			$lang_dir = apply_filters( 'apus_qxygen_languages_directory', $lang_dir );

			// Traditional WordPress plugin locale filter
			$locale = apply_filters( 'plugin_locale', get_locale(), 'apus-qxygen' );
			$mofile = sprintf( '%1$s-%2$s.mo', 'apus-qxygen', $locale );

			// Setup paths to current locale file
			$mofile_local  = $lang_dir . $mofile;
			$mofile_global = WP_LANG_DIR . '/apus-qxygen/' . $mofile;

			if ( file_exists( $mofile_global ) ) {
				// Look in global /wp-content/languages/apus-qxygen folder
				load_textdomain( 'apus-qxygen', $mofile_global );
			} elseif ( file_exists( $mofile_local ) ) {
				// Look in local /wp-content/plugins/apus-qxygen/languages/ folder
				load_textdomain( 'apus-qxygen', $mofile_local );
			} else {
				// Load the default language files
				load_plugin_textdomain( 'apus-qxygen', false, $lang_dir );
			}
		}
	}
}

function Apus_Qxygen() {
	return Apus_Qxygen::getInstance();
}

add_action( 'plugins_loaded', 'Apus_Qxygen' );