<?php
/**
 * The template for displaying 404 pages (not found)
 *
 * @package WordPress
 * @subpackage Qxygen
 * @since Qxygen 1.0
 */
/*
*Template Name: 404 Page
*/
get_header();
$style = '';
$bg_image = qxygen_get_config('404_bg_image');
$top_image = qxygen_get_config('404_image');
if( isset($bg_image['url']) && !empty($bg_image['url']) ) {
    $style = 'style="background-image:url('. $bg_image['url'] .');"';
}
?>

<section class="page-404" <?php echo trim($style); ?>>
	<div id="main-container" class="inner">
		<div id="main-content" class="main-page">
			<section class="error-404 not-found text-center">
				<div class="inner-page-404">

					<?php if( isset($top_image['url']) && !empty($top_image['url']) ) { ?>
						<div class="img-top">
							<img src="<?php echo esc_url($top_image['url']); ?>" alt="<?php esc_attr_e('Image', 'qxygen'); ?>">
						</div>
					<?php } else { ?>
						<div class="img-top">
							<img src="<?php echo esc_url( get_template_directory_uri().'/images/404.png'); ?>" alt="<?php esc_attr_e('Image', 'qxygen'); ?>">
						</div>
					<?php } ?>

					<?php
					$title_404 = qxygen_get_config('404_title');
					$description_404 = qxygen_get_config('404_description');
					if( !empty($title_404) ) { ?>
						<h4 class="title"><?php echo esc_html($title_404); ?></h4>
					<?php } else { ?>
						<h4 class="title"><?php esc_html_e('Oops Page Not Found', 'qxygen'); ?></h4>
					<?php }

					if( !empty($description_404) ) { ?>
						<div class="description">
							<?php echo esc_html($description_404); ?>	
						</div>
					<?php } else { ?>
						<div class="description">
							<?php esc_html_e('It looks like nothing was found at this location. Maybe try again?', 'qxygen'); ?>	
						</div>
					<?php } ?>

					<a class="text-underline text-white" href="<?php echo esc_url(home_url('/')); ?>"><?php echo esc_html__('BACK TO HOME','qxygen') ?></a>

				</div>
			</section><!-- .error-404 -->
		</div><!-- .content-area -->
	</div>
</section>
<?php get_footer(); ?>