<?php
if ( !function_exists ('qxygen_custom_styles') ) {
	function qxygen_custom_styles() {
		global $post;	
		
		ob_start();	
		?>
		
			<?php
				$main_font = qxygen_get_config('main_font');
				$main_font_family = isset($main_font['font-family']) ? $main_font['font-family'] : false;
				$main_font_size = isset($main_font['font-size']) ? $main_font['font-size'] : false;
				$main_font_weight = isset($main_font['font-weight']) ? $main_font['font-weight'] : false;
			?>
			<?php if ( $main_font_family ): ?>
				/* Main Font */
				.btn,
				body
				{
					font-family:  <?php echo '\'' . $main_font_family . '\','; ?> sans-serif;
				}
			<?php endif; ?>
			<?php if ( $main_font_size ): ?>
				/* Main Font Size */
				body
				{
					font-size: <?php echo esc_html($main_font_size); ?>;
				}
			<?php endif; ?>
			<?php if ( $main_font_weight ): ?>
				/* Main Font Weight */
				body
				{
					font-weight: <?php echo esc_html($main_font_weight); ?>;
				}
			<?php endif; ?>


			<?php
				$heading_font = qxygen_get_config('heading_font');
				$heading_font_family = isset($heading_font['font-family']) ? $heading_font['font-family'] : false;
				$heading_font_weight = isset($heading_font['font-weight']) ? $heading_font['font-weight'] : false;
			?>
			<?php if ( $heading_font_family ): ?>
				/* Heading Font */
				h1, h2, h3, h4, h5, h6
				{
					font-family:  <?php echo '\'' . $heading_font_family . '\','; ?> sans-serif;
				}			
			<?php endif; ?>

			<?php if ( $heading_font_weight ): ?>
				/* Heading Font Weight */
				h1, h2, h3, h4, h5, h6
				{
					font-weight: <?php echo esc_html($heading_font_weight); ?>;
				}			
			<?php endif; ?>


			<?php if ( qxygen_get_config('main_color') != "" ) : ?>
				/* seting background main */
				.apus-social-share a:hover, .apus-social-share a:active,.tagcloud a:hover, .tagcloud a:focus, .tagcloud a.active,
				.add-fix-top,.slick-carousel .slick-dots li.slick-active,.post-navigation .nav-links > * > a:hover .meta-nav,
				.pagination > span.current, .pagination > a.current, .pagination-links > span.current, .pagination-links > a.current, .apus-pagination > span.current, .apus-pagination > a.current,
				.pagination > span:focus, .pagination > span:hover, .pagination > a:focus, .pagination > a:hover, .pagination-links > span:focus, .pagination-links > span:hover, .pagination-links > a:focus, .pagination-links > a:hover, .apus-pagination > span:focus, .apus-pagination > span:hover, .apus-pagination > a:focus, .apus-pagination > a:hover,
				.bg-theme
				{				
					background-color: <?php echo esc_html( qxygen_get_config('main_color') ) ?>;
				}

				.st_theme .elementor-counter:hover::before {
					background-color: <?php echo esc_html( qxygen_get_config('main_color') ) ?> !important;
				}
				/* setting color*/
				.post-layout .meta a:hover, .post-layout .meta a:focus,.search-header-inner .btn:hover, .search-header-inner .btn:focus,
				.sidebar .widget-search .btn:hover, .sidebar .widget-search .btn:focus, .apus-sidebar .widget-search .btn:hover, .apus-sidebar .widget-search .btn:focus,.posts-list .top-info a:hover, .posts-list .top-info a:focus,
				.apus-breadscrumb .breadcrumb .active,
				.top-testimonial-des::before,.apartment-more:hover, .apartment-more:focus,
				a:hover, 
				a:focus
				{
					color: <?php echo esc_html( qxygen_get_config('main_color') ) ?>;
				}
				.st_theme .elementor-counter:hover .elementor-counter-number-wrapper,
				.text-theme{
					color: <?php echo esc_html( qxygen_get_config('main_color') ) ?> !important;
				}

				/* setting border color*/	
				.wp-block-quote, blockquote,						
				.border-theme
				{
					border-color: <?php echo esc_html( qxygen_get_config('main_color') ) ?> !important;
				}

			<?php endif; ?>

			<?php if ( qxygen_get_config('button_color') != "" ) : ?>
				/* seting background main */
				.slick-carousel .slick-arrow,
				.btn-theme
				{
					background-color: <?php echo esc_html( qxygen_get_config('button_color') ) ?> ;
					border-color: <?php echo esc_html( qxygen_get_config('button_color') ) ?> ;
				}				
				.btn-theme.btn-outline{
					border-color: <?php echo esc_html( qxygen_get_config('button_color') ) ?> ;
					color: <?php echo esc_html( qxygen_get_config('button_color') ) ?> ;
				}
			<?php endif; ?>
			<?php if ( qxygen_get_config('button_hover_color') != "" ) : ?>
				/* seting background main */
				.slick-carousel .slick-arrow:hover,.slick-carousel .slick-arrow:focus,
				.btn-theme:hover,.btn-theme:focus,
				.btn-theme.btn-outline:hover, .btn-theme.btn-outline:focus{
					border-color: <?php echo esc_html( qxygen_get_config('button_hover_color') ) ?> ;
					background-color: <?php echo esc_html( qxygen_get_config('button_hover_color') ) ?> ;
				}
			<?php endif; ?>
	<?php
		$content = ob_get_clean();
		$content = str_replace(array("\r\n", "\r"), "\n", $content);
		$lines = explode("\n", $content);
		$new_lines = array();
		foreach ($lines as $i => $line) {
			if (!empty($line)) {
				$new_lines[] = trim($line);
			}
		}		
		return implode($new_lines);
	}
}