<?php

// Apartment Archive settings
function qxygen_apartment_redux_config($sections, $sidebars, $columns) {
    
    $sections[] = array(
        'icon' => 'el el-website',
        'title' => esc_html__('Apartment Settings', 'qxygen'),
        'fields' => array(
            array(
                'id' => 'apartments_breadcrumb_setting',
                'icon' => true,
                'type' => 'info',
                'raw' => '<h3 style="margin: 0;"> '.esc_html__('Breadcrumbs Setting', 'qxygen').'</h3>',
            ),
            array(
                'id' => 'apartments_breadcrumbs',
                'type' => 'switch',
                'title' => esc_html__('Breadcrumbs', 'qxygen'),
                'default' => 1
            ),
            array(
                'title' => esc_html__('Breadcrumbs Background Color', 'qxygen'),
                'subtitle' => '<em>'.esc_html__('The breadcrumbs background color of the site.', 'qxygen').'</em>',
                'id' => 'apartments_breadcrumb_color',
                'type' => 'color',
                'transparent' => false,
            ),
            array(
                'id' => 'apartments_breadcrumb_image',
                'type' => 'media',
                'title' => esc_html__('Breadcrumbs Background', 'qxygen'),
                'subtitle' => esc_html__('Upload a .jpg or .png image that will be your breadcrumbs.', 'qxygen'),
            ),
            array(
                'id' => 'apartments_action_image',
                'type' => 'media',
                'title' => esc_html__('Hover Item Background', 'qxygen'),
                'subtitle' => esc_html__('Upload a .jpg or .png image that will be your Item Apartment.', 'qxygen'),
            ),
        )
    );
    // Archive settings
    $sections[] = array(
        'title' => esc_html__('Apartments Archives', 'qxygen'),
        'subsection' => true,
        'fields' => array(
            array(
                'id' => 'apartments_general_setting',
                'icon' => true,
                'type' => 'info',
                'raw' => '<h3 style="margin: 0;"> '.esc_html__('General Setting', 'qxygen').'</h3>',
            ),
            array(
                'id' => 'apartments_style',
                'type' => 'select',
                'title' => esc_html__('Apartment Style', 'qxygen'),
                'options' => array(
                    'v1' => esc_html__('Style 1', 'qxygen'),
                    'v2' => esc_html__('Style 2', 'qxygen'),
                    'v3' => esc_html__('Style 3', 'qxygen'),
                    'v4' => esc_html__('Style 4', 'qxygen'),
                ),
                'default' => 'v1'
            ),
            array(
                'id' => 'apartments_columns',
                'type' => 'select',
                'title' => esc_html__('Apartment Columns', 'qxygen'),
                'options' => $columns,
                'default' => 3,
            ),
            array(
                'id' => 'number_apartments_per_page',
                'type' => 'text',
                'title' => esc_html__('Number of Apartments Per Page', 'qxygen'),
                'default' => 12,
                'min' => '1',
                'step' => '1',
                'max' => '100',
                'type' => 'slider'
            ),
            array(
                'id' => 'apartments_sidebar_setting',
                'icon' => true,
                'type' => 'info',
                'raw' => '<h3 style="margin: 0;"> '.esc_html__('Sidebar Setting', 'qxygen').'</h3>',
            ),
            array(
                'id' => 'apartments_fullwidth',
                'type' => 'switch',
                'title' => esc_html__('Is Full Width?', 'qxygen'),
                'default' => false
            ),
            array(
                'id' => 'apartments_layout',
                'type' => 'image_select',
                'compiler' => true,
                'title' => esc_html__('Archive Apartment Layout', 'qxygen'),
                'subtitle' => esc_html__('Select the layout you want to apply on your archive apartment page.', 'qxygen'),
                'options' => array(
                    'main' => array(
                        'title' => esc_html__('Main Content', 'qxygen'),
                        'alt' => esc_html__('Main Content', 'qxygen'),
                        'img' => get_template_directory_uri() . '/inc/assets/images/screen1.png'
                    ),
                    'left-main' => array(
                        'title' => esc_html__('Left Sidebar - Main Content', 'qxygen'),
                        'alt' => esc_html__('Left Sidebar - Main Content', 'qxygen'),
                        'img' => get_template_directory_uri() . '/inc/assets/images/screen2.png'
                    ),
                    'main-right' => array(
                        'title' => esc_html__('Main Content - Right Sidebar', 'qxygen'),
                        'alt' => esc_html__('Main Content - Right Sidebar', 'qxygen'),
                        'img' => get_template_directory_uri() . '/inc/assets/images/screen3.png'
                    ),
                ),
                'default' => 'main-right'
            ),
            array(
                'id' => 'apartments_left_sidebar',
                'type' => 'select',
                'title' => esc_html__('Archive Left Sidebar', 'qxygen'),
                'subtitle' => esc_html__('Choose a sidebar for left sidebar.', 'qxygen'),
                'options' => $sidebars
            ),
            array(
                'id' => 'apartments_right_sidebar',
                'type' => 'select',
                'title' => esc_html__('Archive Right Sidebar', 'qxygen'),
                'subtitle' => esc_html__('Choose a sidebar for right sidebar.', 'qxygen'),
                'options' => $sidebars
            ),
        )
    );
    
    
    // Apartment Page
    $sections[] = array(
        'title' => esc_html__('Apartment Single', 'qxygen'),
        'subsection' => true,
        'fields' => array(
            array(
                'id' => 'apartment_general_setting',
                'icon' => true,
                'type' => 'info',
                'raw' => '<h3 style="margin: 0;"> '.esc_html__('General Setting', 'qxygen').'</h3>',
            ),
            array(
                'id' => 'apartment_fullwidth',
                'type' => 'switch',
                'title' => esc_html__('Is Full Width?', 'qxygen'),
                'default' => false
            ),
            array(
                'id' => 'show_apartment_recent',
                'type' => 'switch',
                'title' => esc_html__('Show Recent Apartments', 'qxygen'),
                'default' => 1
            ),
            array(
                'id' => 'number_apartment_recent',
                'type' => 'text',
                'title' => esc_html__('Number of related posts to show', 'qxygen'),
                'required' => array('show_apartment_recent', '=', '1'),
                'default' => 3,
                'min' => '1',
                'step' => '1',
                'max' => '20',
                'type' => 'slider'
            ),
            array(
                'id' => 'recent_apartment_columns',
                'type' => 'select',
                'title' => esc_html__('Recent Apartments Columns', 'qxygen'),
                'required' => array('show_apartment_recent', '=', '1'),
                'options' => $columns,
                'default' => 3
            ),
            array(
                'id' => 'apartment_sidebar_setting',
                'icon' => true,
                'type' => 'info',
                'raw' => '<h3 style="margin: 0;"> '.esc_html__('Sidebar Setting', 'qxygen').'</h3>',
            ),
            array(
                'id' => 'apartment_layout',
                'type' => 'image_select',
                'compiler' => true,
                'title' => esc_html__('Single Apartment Sidebar Layout', 'qxygen'),
                'subtitle' => esc_html__('Select the layout you want to apply on your Single Apartment Page.', 'qxygen'),
                'options' => array(
                	'main' => array(
                        'title' => esc_html__('Main Content', 'qxygen'),
                        'alt' => esc_html__('Main Content', 'qxygen'),
                        'img' => get_template_directory_uri() . '/inc/assets/images/screen1.png'
                    ),
                    'left-main' => array(
                        'title' => esc_html__('Left - Main Sidebar', 'qxygen'),
                        'alt' => esc_html__('Left - Main Sidebar', 'qxygen'),
                        'img' => get_template_directory_uri() . '/inc/assets/images/screen2.png'
                    ),
                    'main-right' => array(
                        'title' => esc_html__('Main - Right Sidebar', 'qxygen'),
                        'alt' => esc_html__('Main - Right Sidebar', 'qxygen'),
                        'img' => get_template_directory_uri() . '/inc/assets/images/screen3.png'
                    ),
                ),
                'default' => 'main-right'
            ),
            array(
                'id' => 'apartment_left_sidebar',
                'type' => 'select',
                'title' => esc_html__('Archive Left Sidebar', 'qxygen'),
                'subtitle' => esc_html__('Choose a sidebar for left sidebar.', 'qxygen'),
                'options' => $sidebars
            ),
            array(
                'id' => 'apartment_right_sidebar',
                'type' => 'select',
                'title' => esc_html__('Archive Right Sidebar', 'qxygen'),
                'subtitle' => esc_html__('Choose a sidebar for right sidebar.', 'qxygen'),
                'options' => $sidebars
            ),

        )
    );

    return $sections;
}
add_filter( 'qxygen_redux_framwork_configs', 'qxygen_apartment_redux_config', 30, 3 );