<?php

function qxygen_apartment_theme_folder($folder) {
    return "template-apartment";
}
add_filter( 'apus-qxygen-theme-folder-name', 'qxygen_apartment_theme_folder', 10 );

if ( !function_exists('qxygen_apartment_content_class') ) {
    function qxygen_apartment_content_class( $class ) {
        $prefix = 'apartments';
        if ( is_singular( 'apartment' ) ) {
            $prefix = 'apartment';
        }
        if ( qxygen_get_config($prefix.'_fullwidth') ) {
            return 'container-fluid';
        }
        return $class;
    }
}
add_filter( 'qxygen_apartment_content_class', 'qxygen_apartment_content_class', 1 , 1  );


if ( !function_exists('qxygen_get_apartment_layout_configs') ) {
    function qxygen_get_apartment_layout_configs() {
        $prefix = 'apartments';
        if ( is_singular( 'apartment' ) ) {
            $prefix = 'apartment';
        }
        $left = qxygen_get_config($prefix.'_left_sidebar');
        $right = qxygen_get_config($prefix.'_right_sidebar');

        switch ( qxygen_get_config($prefix.'_layout') ) {
            case 'left-main':
                if ( is_active_sidebar( $left ) ) {
                    $configs['left'] = array( 'sidebar' => $left, 'class' => 'col-md-4 col-sm-12 col-xs-12'  );
                    $configs['main'] = array( 'class' => 'col-md-8 col-sm-12 col-xs-12 pull-right' );
                }
                break;
            case 'main-right':
                if ( is_active_sidebar( $right ) ) {
                    $configs['right'] = array( 'sidebar' => $right,  'class' => 'col-md-4 col-sm-12 col-xs-12 pull-right' ); 
                    $configs['main'] = array( 'class' => 'col-md-8 col-sm-12 col-xs-12' );
                }
                break;
            case 'main':
                $configs['main'] = array( 'class' => 'col-md-12 col-sm-12 col-xs-12' );
                break;
            default:
                $configs['right'] = array( 'sidebar' => 'sidebar-default',  'class' => 'col-md-4 col-xs-12' ); 
                $configs['main'] = array( 'class' => 'col-md-8 col-xs-12' );
                break;
        }
        if ( empty($configs) ) {
            $configs['right'] = array( 'sidebar' => 'sidebar-default',  'class' => 'col-md-4 col-xs-12' ); 
            $configs['main'] = array( 'class' => 'col-md-8 col-xs-12' );
        }
        return $configs; 
    }
}

add_action( 'pre_get_posts', 'qxygen_apartment_archive' );
function qxygen_apartment_archive($query) {
    $suppress_filters = ! empty( $query->query_vars['suppress_filters'] ) ? $query->query_vars['suppress_filters'] : '';

    if ( ! is_post_type_archive( 'apartment' ) || ! $query->is_main_query() || is_admin() || $query->query_vars['post_type'] != 'apartment' || $suppress_filters ) {
        return;
    }

    $limit = qxygen_get_config('number_apartments_per_page', 10);
    $query_vars = &$query->query_vars;
    $query_vars['posts_per_page'] = $limit;
    $query->query_vars = $query_vars;
    
    return $query;
}
