<?php

if ( !function_exists( 'qxygen_page_metaboxes' ) ) {
	function qxygen_page_metaboxes(array $metaboxes) {
		global $wp_registered_sidebars;
        $sidebars = array();

        if ( !empty($wp_registered_sidebars) ) {
            foreach ($wp_registered_sidebars as $sidebar) {
                $sidebars[$sidebar['id']] = $sidebar['name'];
            }
        }
        $headers = array_merge( array('global' => esc_html__( 'Global Setting', 'qxygen' )), qxygen_get_header_layouts() );
        $footers = array_merge( array('global' => esc_html__( 'Global Setting', 'qxygen' )), qxygen_get_footer_layouts() );

		$prefix = 'apus_page_';
	    $fields = array(
			array(
				'name' => esc_html__( 'Select Layout', 'qxygen' ),
				'id'   => $prefix.'layout',
				'type' => 'select',
				'options' => array(
					'main' => esc_html__('Main Content Only', 'qxygen'),
					'left-main' => esc_html__('Left Sidebar - Main Content', 'qxygen'),
					'main-right' => esc_html__('Main Content - Right Sidebar', 'qxygen')
				)
			),
			array(
                'id' => $prefix.'fullwidth',
                'type' => 'select',
                'name' => esc_html__('Is Full Width?', 'qxygen'),
                'default' => 'no',
                'options' => array(
                    'no' => esc_html__('No', 'qxygen'),
                    'yes' => esc_html__('Yes', 'qxygen')
                )
            ),
            array(
                'id' => $prefix.'left_sidebar',
                'type' => 'select',
                'name' => esc_html__('Left Sidebar', 'qxygen'),
                'options' => $sidebars
            ),
            array(
                'id' => $prefix.'right_sidebar',
                'type' => 'select',
                'name' => esc_html__('Right Sidebar', 'qxygen'),
                'options' => $sidebars
            ),
            array(
                'id' => $prefix.'show_breadcrumb',
                'type' => 'select',
                'name' => esc_html__('Show Breadcrumb?', 'qxygen'),
                'options' => array(
                    'no' => esc_html__('No', 'qxygen'),
                    'yes' => esc_html__('Yes', 'qxygen')
                ),
                'default' => 'yes',
            ),
            array(
                'id' => $prefix.'breadcrumb_color',
                'type' => 'colorpicker',
                'name' => esc_html__('Breadcrumb Background Color', 'qxygen')
            ),
            array(
                'id' => $prefix.'breadcrumb_image',
                'type' => 'file',
                'name' => esc_html__('Breadcrumb Background Image', 'qxygen')
            ),
            array(
                'id' => $prefix.'header_type',
                'type' => 'select',
                'name' => esc_html__('Header Layout Type', 'qxygen'),
                'description' => esc_html__('Choose a header for your website.', 'qxygen'),
                'options' => $headers,
                'default' => 'global'
            ),
            array(
                'id' => $prefix.'header_transparent',
                'type' => 'select',
                'name' => esc_html__('Header Transparent', 'qxygen'),
                'description' => esc_html__('Choose a header for your website.', 'qxygen'),
                'options' => array(
                    'no' => esc_html__('No', 'qxygen'),
                    'yes' => esc_html__('Yes', 'qxygen')
                ),
                'default' => 'global'
            ),
            array(
                'id' => $prefix.'header_position',
                'type' => 'select',
                'name' => esc_html__('Header Position', 'qxygen'),
                'description' => esc_html__('Choose a header for your website.', 'qxygen'),
                'options' => array(
                    '' => esc_html__('Default', 'qxygen'),
                    'header_p_left' => esc_html__('Left', 'qxygen'),
                    'header_p_right' => esc_html__('Right', 'qxygen'),
                ),
                'default' => 'global'
            ),
            array(
                'id' => $prefix.'footer_type',
                'type' => 'select',
                'name' => esc_html__('Footer Layout Type', 'qxygen'),
                'description' => esc_html__('Choose a footer for your website.', 'qxygen'),
                'options' => $footers,
                'default' => 'global'
            ),
            array(
                'id' => $prefix.'extra_class',
                'type' => 'text',
                'name' => esc_html__('Extra Class', 'qxygen'),
                'description' => esc_html__('If you wish to style particular content element differently, then use this field to add a class name and then refer to it in your css file.', 'qxygen')
            )
    	);
		
	    $metaboxes[$prefix . 'display_setting'] = array(
			'id'                        => $prefix . 'display_setting',
			'title'                     => esc_html__( 'Display Settings', 'qxygen' ),
			'object_types'              => array( 'page' ),
			'context'                   => 'normal',
			'priority'                  => 'high',
			'show_names'                => true,
			'fields'                    => $fields
		);

	    return $metaboxes;
	}
}
add_filter( 'cmb2_meta_boxes', 'qxygen_page_metaboxes' );

if ( !function_exists( 'qxygen_cmb2_style' ) ) {
	function qxygen_cmb2_style() {
		wp_enqueue_style( 'qxygen-cmb2-style', get_template_directory_uri() . '/inc/vendors/cmb2/assets/style.css', array(), '1.0' );
	}
}
add_action( 'admin_enqueue_scripts', 'qxygen_cmb2_style' );


