<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

if( ! class_exists( 'Qxygen_Elementor_Extensions' ) ) {
    final class Qxygen_Elementor_Extensions {

        private static $_instance = null;

        
        public function __construct() {
            add_action( 'elementor/elements/categories_registered', array( $this, 'add_widget_categories' ) );
            add_action( 'init', array( $this, 'elementor_widgets' ),  100 );
            add_filter( 'qxygen_generate_post_builder', array( $this, 'render_post_builder' ), 10, 2 );

            add_action( 'elementor/controls/controls_registered', array( $this, 'modify_controls' ), 10, 1 );
            add_action('elementor/editor/before_enqueue_styles', array( $this, 'style' ) );
            add_filter( 'elementor/controls/animations/additional_animations', array( $this, 'additional_animations' ), 10 );
        }

        public static function instance () {
            if ( is_null( self::$_instance ) ) {
                self::$_instance = new self();
            }
            return self::$_instance;
        }
        
        public function add_widget_categories( $elements_manager ) {
            $elements_manager->add_category(
                'qxygen-elements',
                [
                    'title' => esc_html__( 'Qxygen Elements', 'qxygen' ),
                    'icon' => 'fa fa-shopping-bag',
                ]
            );

            $elements_manager->add_category(
                'qxygen-header-elements',
                [
                    'title' => esc_html__( 'Qxygen Header Elements', 'qxygen' ),
                    'icon' => 'fa fa-shopping-bag',
                ]
            );

        }

        public function elementor_widgets() {
            // general elements
            get_template_part( 'inc/vendors/elementor/widgets/heading' );
            get_template_part( 'inc/vendors/elementor/widgets/icon_list' );
            get_template_part( 'inc/vendors/elementor/widgets/list_info' );
            get_template_part( 'inc/vendors/elementor/widgets/posts' );
            get_template_part( 'inc/vendors/elementor/widgets/call_to_action' );
            get_template_part( 'inc/vendors/elementor/widgets/features_box' );
            get_template_part( 'inc/vendors/elementor/widgets/social_links' );
            get_template_part( 'inc/vendors/elementor/widgets/testimonials' );
            get_template_part( 'inc/vendors/elementor/widgets/brands' );
            get_template_part( 'inc/vendors/elementor/widgets/process' );
            get_template_part( 'inc/vendors/elementor/widgets/popup_video' );
            get_template_part( 'inc/vendors/elementor/widgets/instagram' );
            get_template_part( 'inc/vendors/elementor/widgets/banner' );
            get_template_part( 'inc/vendors/elementor/widgets/schedule' );
            get_template_part( 'inc/vendors/elementor/widgets/countdown' );
            get_template_part( 'inc/vendors/elementor/widgets/nav_menu' );
            get_template_part( 'inc/vendors/elementor/widgets/team' );
            get_template_part( 'inc/vendors/elementor/widgets/agents' );

            get_template_part( 'inc/vendors/elementor/widgets/tabs' );
            get_template_part( 'inc/vendors/elementor/widgets/maps' );
            get_template_part( 'inc/vendors/elementor/widgets/gallery' );
            
            get_template_part( 'inc/vendors/elementor/widgets/amenities' );
            get_template_part( 'inc/vendors/elementor/widgets/availability' );

            // header elements
            get_template_part( 'inc/vendors/elementor/header-widgets/logo' );
            get_template_part( 'inc/vendors/elementor/header-widgets/primary_menu' );
            get_template_part( 'inc/vendors/elementor/header-widgets/search_form' );
            get_template_part( 'inc/vendors/elementor/header-widgets/header-sidebar' );

            if ( qxygen_is_mailchimp_activated() ) {
                get_template_part( 'inc/vendors/elementor/widgets/mailchimp' );
            }
            
            if ( qxygen_is_revslider_activated() ) {
                get_template_part( 'inc/vendors/elementor/widgets/revslider' );
            }

            if ( qxygen_is_apus_qxygen_activated() ) {
                get_template_part( 'inc/vendors/elementor/widgets/apartments' );
            }
        }

        public function style() {
            wp_enqueue_style('qxygen-flaticon',  get_template_directory_uri() . '/css/flaticon.css');
        }

        public function modify_controls( $controls_registry ) {
            // Get existing icons
            $icons = $controls_registry->get_control( 'icon' )->get_settings( 'options' );
            // Append new icons
            $new_icons = array_merge(
                array(
                    'flaticon-loupe' => 'flaticon-loupe', 
                    'flaticon-share' => 'flaticon-share', 
                    'flaticon-next' => 'flaticon-next', 
                    'flaticon-right-arrow' => 'flaticon-right-arrow', 
                    'flaticon-left-arrow' => 'flaticon-left-arrow', 
                    'flaticon-left-arrow-1' => 'flaticon-left-arrow-1', 
                    'flaticon-place' => 'flaticon-place', 
                    'flaticon-mail' => 'flaticon-mail', 
                    'flaticon-phone-call' => 'flaticon-phone-call', 
                    'flaticon-upload' => 'flaticon-upload', 
                    'flaticon-zoom-in' => 'flaticon-zoom-in', 
                    'flaticon-headphones' => 'flaticon-headphones', 
                    'flaticon-cloud-computing' => 'flaticon-cloud-computing', 
                    'flaticon-apartment' => 'flaticon-apartment', 
                    'flaticon-garage' => 'flaticon-garage', 
                    'flaticon-dog-house' => 'flaticon-dog-house',
                    'flaticon-fast' => 'flaticon-fast',
                    'flaticon-swimming-pool' => 'flaticon-swimming-pool',
                    'flaticon-meditation' => 'flaticon-meditation',
                    'flaticon-next-1' => 'flaticon-next-1',
                    'flaticon-left-arrow-2' => 'flaticon-left-arrow-2',
                    'flaticon-home' => 'flaticon-home',
                    'flaticon-right-arrow-1' => 'flaticon-right-arrow-1',
                    'flaticon-left-arrow-3' => 'flaticon-left-arrow-3'
                ),
                $icons                
            );
            // Then we set a new list of icons as the options of the icon control
            $controls_registry->get_control( 'icon' )->set_settings( 'options', $new_icons );
        }

        public function additional_animations($animations = array()) {
            $additional_animations = array(
                'ApusTheme' => [
                    'moveInDown' => esc_html__('Move In Down', 'qxygen'),
                    'moveInLeft' => esc_html__('Move In Left', 'qxygen'),
                    'moveInRight' => esc_html__('Move In Right', 'qxygen'),
                    'moveInUp' => esc_html__('Move In Up', 'qxygen'),
                    'moveOutDown' => esc_html__('Move Out Down', 'qxygen'),
                    'moveOutLeft' => esc_html__('Move Out Left', 'qxygen'),
                    'moveOutRight' => esc_html__('Move Out Right', 'qxygen'),
                    'moveOutUp' => esc_html__('Move Out Up', 'qxygen'),
                ],
            );
            return array_merge( $animations, $additional_animations );
        }

        public function render_page_content($post_id) {
            if ( class_exists( 'Elementor\Core\Files\CSS\Post' ) ) {
                $css_file = new Elementor\Core\Files\CSS\Post( $post_id );
                $css_file->enqueue();
            }

            return Elementor\Plugin::instance()->frontend->get_builder_content_for_display( $post_id );
        }

        public function render_post_builder($html, $post) {
            if ( !empty($post) && !empty($post->ID) ) {
                return $this->render_page_content($post->ID);
            }
            return $html;
        }
    }
}

if ( did_action( 'elementor/loaded' ) ) {
    // Finally initialize code
    Qxygen_Elementor_Extensions::instance();
}