<?php

//namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Qxygen_Elementor_Header_Sidebar extends Elementor\Widget_Base {

	public function get_name() {
        return 'apus_element_header_sidebar';
    }

	public function get_title() {
        return esc_html__( 'Apus Header Sidebar', 'qxygen' );
    }
    
	public function get_categories() {
        return [ 'qxygen-header-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Content', 'qxygen' ),
                'tab' => Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'icon',
            [
                'label' => esc_html__( 'Button Icon', 'qxygen' ),
                'type' => Elementor\Controls_Manager::ICON,
                'label_block' => true,
            ]
        );

        $ele_obj = \Elementor\Plugin::$instance;
        $templates = $ele_obj->templates_manager->get_source( 'local' )->get_items();

        if ( empty( $templates ) ) {

            $this->add_control(
                'no_templates',
                array(
                    'label' => false,
                    'type'  => Elementor\Controls_Manager::RAW_HTML,
                    'raw'   => $this->empty_templates_message(),
                )
            );

        } else {

            $options = [
                '0' => '— ' . esc_html__( 'Select', 'qxygen' ) . ' —',
            ];

            $types = [];

            foreach ( $templates as $template ) {
                $options[ $template['template_id'] ] = $template['title'] . ' (' . $template['type'] . ')';
                $types[ $template['template_id'] ] = $template['type'];
            }

            $this->add_control(
                'item_template_id',
                [
                    'label'       => esc_html__( 'Choose Template', 'qxygen' ),
                    'type'        => Elementor\Controls_Manager::SELECT,
                    'default'     => '0',
                    'options'     => $options,
                    'types'       => $types,
                    'label_block' => 'true'
                ]
            );
        }

   		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'qxygen' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'qxygen' ),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_title',
            [
                'label' => esc_html__( 'Style', 'qxygen' ),
                'tab' => Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs(
            'style_tabs'
        );

            $this->start_controls_tab(
                'style_normal_tab',
                [
                    'label' => esc_html__( 'Normal', 'qxygen' ),
                ]
            );

            $this->add_control(
                'color',
                [
                    'label' => esc_html__( 'Color', 'qxygen' ),
                    'type' => Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .header-sidebar-btn' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .action-sidebar' => 'border-color: {{VALUE}};',
                        '{{WRAPPER}} .action-sidebar::before' => 'background-color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'bg_color',
                [
                    'label' => esc_html__( 'Background Color', 'qxygen' ),
                    'type' => Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .header-sidebar-btn' => 'background-color: {{VALUE}};',
                    ],
                ]
            );

            $this->end_controls_tab();

            $this->start_controls_tab(
                'style_hover_tab',
                [
                    'label' => esc_html__( 'Hover', 'qxygen' ),
                ]
            );

            $this->add_control(
                'hv_color',
                [
                    'label' => esc_html__( 'Hover Color', 'qxygen' ),
                    'type' => Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .header-sidebar-btn:hover' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .header-sidebar-btn:focus' => 'color: {{VALUE}};',
                        '{{WRAPPER}} .header-sidebar-btn:hover .action-sidebar' => 'border-color: {{VALUE}};',
                        '{{WRAPPER}} .header-sidebar-btn:hover .action-sidebar::before' => 'background-color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'bg_hv_color',
                [
                    'label' => esc_html__( 'Hover Background Color', 'qxygen' ),
                    'type' => Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .header-sidebar-btn:hover' => 'background-color: {{VALUE}};',
                        '{{WRAPPER}} .header-sidebar-btn:focus' => 'background-color: {{VALUE}};',
                    ],
                ]
            );

            $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_responsive_control(
            'button_width',
            [
                'label' => esc_html__( 'Button Width', 'qxygen' ),
                'type' => Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .header-sidebar-btn' => 'width: {{SIZE}}{{UNIT}}; max-width: {{SIZE}}{{UNIT}}',
                ],
            ]
        );
        
        $this->add_responsive_control(
            'icon_height',
            [
                'label' => esc_html__( 'Button Height', 'qxygen' ),
                'type' => Elementor\Controls_Manager::SLIDER,
                'range' => [
                    'px' => [
                        'min' => 0,
                        'max' => 100,
                    ],
                ],
                'selectors' => [
                    '{{WRAPPER}} .header-sidebar-btn' => 'height: {{SIZE}}{{UNIT}}; max-height: {{SIZE}}{{UNIT}};line-height: {{SIZE}}{{UNIT}}',
                ],
            ]
        );

        $this->end_controls_section();

    }

	protected function render() {
        $settings = $this->get_settings();

        extract( $settings );

        ?>
        <div class="widget-header-sidebar <?php echo esc_attr($el_class); ?>">
            <a href="javascript:void(0);" class="header-sidebar-btn">
                <?php if ( $icon ) { ?>
                    <i class="<?php echo esc_attr($icon); ?>"></i>
                <?php } else { ?>
                    <span class="action-sidebar"></span>
                <?php } ?>
            </a>
            <div class="header-sidebar-wrapper">
                <span class="close-header-sidebar"><i class="ti-close"></i></span>
                <div class="inner">
                    <?php
                    $ele_obj = \Elementor\Plugin::$instance;
                    $content_html = '';

                    if ( !empty($item_template_id) && $item_template_id !== '0' ) {

                        $template_content = $ele_obj->frontend->get_builder_content_for_display( $item_template_id );

                        if ( ! empty( $template_content ) ) {
                            $content_html .= $template_content;

                            if ( \Elementor\Plugin::$instance->editor->is_edit_mode() ) {
                                $link = add_query_arg(
                                    array(
                                        'elementor' => '',
                                    ),
                                    get_permalink( $item_template_id )
                                );

                                $content_html .= sprintf( '<div class="qxygen__edit-cover" data-template-edit-link="%s"><i class="fa fa-pencil"></i><span>%s</span></div>', $link, esc_html__( 'Edit Template', 'qxygen' ) );
                            }
                        } else {
                            $content_html = $this->no_template_content_message();
                        }
                    } else {
                        $content_html = $this->no_templates_message();
                    }

                    echo trim($content_html);
                    ?>
                </div>
            </div>
        </div>
        <?php
    }

    public function no_templates_message() {
        $message = '<span>' . esc_html__( 'Template is not defined. ', 'qxygen' ) . '</span>';

        return sprintf(
            '<div class="no-template-message">%1$s</div>',
            $message
        );
    }

    public function no_template_content_message() {
        $message = '<span>' . esc_html__( 'The sidebar are working. Please, note, that you have to add a template to the library in order to be able to display it inside the sidebar.', 'qxygen' ) . '</span>';

        return sprintf( '<div class="no-template-message">%1$s</div>', $message );
    }

    public function empty_templates_message() {
        return '<div id="elementor-widget-template-empty-templates">
                <div class="elementor-widget-template-empty-templates-icon"><i class="eicon-nerd"></i></div>
                <div class="elementor-widget-template-empty-templates-title">' . esc_html__( 'You Haven’t Saved Templates Yet.', 'qxygen' ) . '</div>
                <div class="elementor-widget-template-empty-templates-footer">' . esc_html__( 'What is Library?', 'qxygen' ) . ' <a class="elementor-widget-template-empty-templates-footer-url" href="https://go.elementor.com/docs-library/" target="_blank">' . esc_html__( 'Read our tutorial on using Library templates.', 'qxygen' ) . '</a></div>
                </div>';
    }
}

Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Qxygen_Elementor_Header_Sidebar );