<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Qxygen_Elementor_Agents extends Widget_Base {

	public function get_name() {
        return 'apus_element_agents';
    }

	public function get_title() {
        return esc_html__( 'Apus Agents', 'qxygen' );
    }

    public function get_icon() {
        return 'fa fa-users';
    }

	public function get_categories() {
        return [ 'qxygen-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Agent', 'qxygen' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();

        $this->add_control(
            'name', [
                'label' => esc_html__( 'Name', 'qxygen' ),
                'type' => Controls_Manager::TEXT,                
                'placeholder' => esc_html__( 'Member Name' , 'qxygen' ),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'job', [
                'label' => esc_html__( 'Job', 'qxygen' ),
                'type' => Controls_Manager::TEXT,                
                'placeholder' => esc_html__( 'Member Job' , 'qxygen' ),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'description', [
                'label' => esc_html__( 'Description', 'qxygen' ),
                'type' => Controls_Manager::TEXTAREA,                
                'label_block' => true,
            ]
        );

        $this->add_control(
            'email', [
                'label' => esc_html__( 'Email', 'qxygen' ),
                'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'info@mywebsite.com' , 'qxygen' ),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'phone', [
                'label' => esc_html__( 'Phone', 'qxygen' ),
                'type' => Controls_Manager::TEXT,                
                'placeholder' => esc_html__( '0123456789', 'qxygen' ),
                'label_block' => true,
            ]
        );
        
        $this->add_control(
            'img_src',
            [
                'name' => 'image',
                'label' => esc_html__( 'Image', 'qxygen' ),
                'type' => Controls_Manager::MEDIA,
                'placeholder'   => esc_html__( 'Upload Image Here', 'qxygen' ),
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'title', [
                'label' => esc_html__( 'Social Title', 'qxygen' ),
                'type' => Controls_Manager::TEXT,
                'default' => esc_html__( 'Social Title' , 'qxygen' ),
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'link',
            [
                'label' => esc_html__( 'Social Link', 'qxygen' ),
                'type' => Controls_Manager::TEXT,
                'input_type' => 'url',
                'placeholder' => esc_html__( 'Enter your social link here', 'qxygen' ),
            ]
        );

        $repeater->add_control(
            'selected_icon',
            [
                'label' => esc_html__( 'Icon', 'qxygen' ),
                'type' => Controls_Manager::ICONS,
                'default' => [
                    'value' => 'fas fa-check',
                    'library' => 'fa-solid',
                ],
                'fa4compatibility' => 'icon',
            ]
        );

        $this->add_control(
            'socials',
            [
                'label' => esc_html__( 'Socials', 'qxygen' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

   		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'qxygen' ),
                'type'          => Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'qxygen' ),
            ]
        );

        $this->end_controls_section();

    }

	protected function render() {
        $settings = $this->get_settings();

        extract( $settings );
        $migration_allowed = Icons_Manager::is_migration_allowed();
        ?>
        <div class="widget-team <?php echo esc_attr($el_class); ?>">

            <?php
                if ( !empty($settings['img_src']['id']) ) {
            ?>
                <div class="team-image">
                    <?php echo qxygen_get_attachment_thumbnail($settings['img_src']['id'], 'full'); ?>
                    
                    <a class="team-popup-btn" href="javascript:void(0);">
                        <i class="flaticon-loupe"></i>
                    </a>                          
                </div>
            <?php } ?>

            <div class="content">
                <?php if ( !empty($name) ) { ?>
                    <div class="name-team">
                        <?php echo trim($name); ?>
                    </div>
                <?php } ?>

                <?php if ( !empty($job) ) { ?>
                    <div class="job">
                        <?php echo trim($job); ?>
                    </div>
                <?php } ?>
            </div>
            <div class="hidden team-popup-wrapper">
                <div class="team-popup-inner">
                    <div class="row">
                        <?php
                            if ( !empty($settings['img_src']['id']) ) {
                        ?>
                            <div class="col-xs-6 smallest-full">
                                <div class="team-image">
                                    <?php echo qxygen_get_attachment_thumbnail($settings['img_src']['id'], 'full'); ?>
                                </div>
                            </div>
                        <?php } ?>

                        <div class="content col-xs-6 smallest-full">
                            <?php if ( !empty($name) ) { ?>
                                <div class="name-team">
                                    <?php echo trim($name); ?>
                                </div>
                            <?php } ?>

                            <?php if ( !empty($job) ) { ?>
                                <div class="job text-theme">
                                    <?php echo trim($job); ?>
                                </div>
                            <?php } ?>

                            <?php if ( !empty($description) ) { ?>
                                <div class="description">                            
                                    <?php echo trim($description); ?>
                                </div>
                            <?php } ?>

                            <div class="contact-info">
                                <div class="title"><?php esc_html_e('Contact:', 'qxygen'); ?></div>
                                <?php if ( !empty($email) ) { ?>
                                    <div class="email">                            
                                        <a href="mailto:<?php echo trim($email); ?>" target="_top"><?php echo trim($email); ?></a>
                                    </div>
                                <?php } ?>

                                <?php if ( !empty($phone) ) { ?>
                                    <div class="phone">                            
                                        <a href="tel:<?php echo trim($phone); ?>"><?php echo trim($phone); ?></a>
                                    </div>
                                <?php } ?>
                            </div>

                            <div class="social-info">
                                <div class="title"><?php esc_html_e('Social Account:', 'qxygen'); ?></div>
                                <ul class="social list-inline">
                                    <?php foreach ($socials as $social) { ?>
                                        <?php 

                                            $migrated = isset( $social['__fa4_migrated']['selected_icon'] );
                                            $is_new = ! isset( $social['icon'] ) && $migration_allowed;

                                        ?>
                                        <?php if ( !empty($social['link']) && !empty($social['icon']) ) { ?>
                                            <li>
                                                <a href="<?php echo esc_url($social['link']);?>" <?php echo trim(!empty($social['title']) ? 'title="'.esc_attr($social['title']).'"' : ''); ?>>
                                                        <?php
                                                        if ( $is_new || $migrated ) {
                                                            Icons_Manager::render_icon( $social['selected_icon'], [ 'aria-hidden' => 'true' ] );
                                                        } else { ?>
                                                                <i class="<?php echo esc_attr( $social['icon'] ); ?>" aria-hidden="true"></i>
                                                        <?php } ?>
                                                </a>
                                            </li>
                                        <?php } ?>
                                    <?php } ?>
                                </ul>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type( new Qxygen_Elementor_Agents );