<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Qxygen_Elementor_Amenities extends Elementor\Widget_Base {

	public function get_name() {
        return 'apus_element_amenities';
    }

	public function get_title() {
        return esc_html__( 'Apus Amenities', 'qxygen' );
    }

	public function get_icon() {
        return 'eicon-bullet-list';
    }

	public function get_categories() {
        return [ 'qxygen-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Amenities', 'qxygen' ),
                'tab' => Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        
        $repeater = new Elementor\Repeater();


        $repeater->add_control(
            'title_text',
            [
                'label' => esc_html__( 'Title', 'qxygen' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'This is the heading', 'qxygen' ),
                'placeholder' => esc_html__( 'Enter your title', 'qxygen' ),
            ]
        );

        $repeater->add_control(
            'icon',
            [
                'label' => esc_html__( 'Icon', 'qxygen' ),
                'type' => Elementor\Controls_Manager::ICON,
                'default' => 'fa fa-star',
            ]
        );

        $repeater->add_control(
            'image',
            [
                'label' => esc_html__( 'Choose Image', 'qxygen' ),
                'type' => Elementor\Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => [
                    'url' => Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $repeater->add_group_control(
            Elementor\Group_Control_Image_Size::get_type(),
            [
                'name' => 'thumbnail', // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `thumbnail_size` and `thumbnail_custom_dimension`.
                'default' => 'full',
                'separator' => 'none',
            ]
        );

        $repeater->add_control(
            'description_text',
            [
                'label' => esc_html__( 'Content', 'qxygen' ),
                'type' => Elementor\Controls_Manager::TEXTAREA,
                'default' => '',
                'placeholder' => esc_html__( 'Enter your description', 'qxygen' ),
                'separator' => 'none',
                'rows' => 10,
                'show_label' => false,
                'condition' => [
                    'style' => 'style1',
                ],
            ]
        );

        $repeater->add_control(
            'link',
            [
                'label' => esc_html__( 'Link to', 'qxygen' ),
                'type' => Elementor\Controls_Manager::URL,
                'placeholder' => esc_html__( 'https://your-link.com', 'qxygen' ),
                'separator' => 'before',
            ]
        );

        $this->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'qxygen' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'input_type' => 'text',
                'placeholder' => esc_html__( 'Enter your title here', 'qxygen' ),
            ]
        );

        $this->add_control(
            'amenities',
            [
                'label' => esc_html__( 'Amenity Items', 'qxygen' ),
                'type' => Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        $this->add_control(
            'show_nav',
            [
                'label' => esc_html__( 'Show Nav', 'qxygen' ),
                'type' => Elementor\Controls_Manager::SWITCHER,
                'default' => '',
                'label_on' => esc_html__( 'Hide', 'qxygen' ),
                'label_off' => esc_html__( 'Show', 'qxygen' ),
            ]
        );

        $this->add_control(
            'show_pagination',
            [
                'label' => esc_html__( 'Show Pagination', 'qxygen' ),
                'type' => Elementor\Controls_Manager::SWITCHER,
                'default' => '',
                'label_on' => esc_html__( 'Hide', 'qxygen' ),
                'label_off' => esc_html__( 'Show', 'qxygen' ),
            ]
        );

        $this->add_control(
            'style',
            [
                'label' => esc_html__( 'Style', 'qxygen' ),
                'type' => Elementor\Controls_Manager::SELECT,
                'options' => array(
                    'style1' => esc_html__('Style 1', 'qxygen'),
                    'style2' => esc_html__('Style 2', 'qxygen'),
                ),
                'default' => 'style1'
            ]
        );

   		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'qxygen' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'qxygen' ),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_title_style',
            [
                'label' => esc_html__( 'Title', 'qxygen' ),
                'tab' => Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Color', 'qxygen' ),
                'type' => Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .widget-title ' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__( 'Typography', 'qxygen' ),
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .widget-title',
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'section_item_style',
            [
                'label' => esc_html__( 'Content', 'qxygen' ),
                'tab' => Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            \Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'label' => esc_html__( 'Background', 'qxygen' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .style2::before',
                'condition' => [
                    'style' => 'style2',
                ],
            ]
        );

        $this->add_control(
            'item_title_color',
            [
                'label' => esc_html__( 'Color Title', 'qxygen' ),
                'type' => Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .title ' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'item_des_color',
            [
                'label' => esc_html__( 'Color Description', 'qxygen' ),
                'type' => Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .description' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_group_control(
            Elementor\Group_Control_Typography::get_type(),
            [
                'label' => esc_html__( 'Typography Title', 'qxygen' ),
                'name' => 'title_item_typography',
                'selector' => '{{WRAPPER}} .title',
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_icon_style',
            [
                'label' => esc_html__( 'Icon', 'qxygen' ),
                'tab' => Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'icon_color',
            [
                'label' => esc_html__( 'Color', 'qxygen' ),
                'type' => Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .amenities-box-icon' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'icon_bg_color',
            [
                'label' => esc_html__( 'Background Color', 'qxygen' ),
                'type' => Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .amenities-box-icon' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

    }

	protected function render() {
        $settings = $this->get_settings();

        extract( $settings );

        
        if ( !empty($amenities) ) {
            ?>
            <div class="widget-amenities <?php echo esc_attr($el_class.' '.$style); ?>">
                <?php if ( $title ) { ?>
                    <h2 class="widget-title no-margin"><?php echo trim($title); ?></h2>
                <?php } ?>
                <div class="slick-carousel" data-items="1" data-smallmedium="1" data-extrasmall="1" data-pagination="<?php echo esc_attr($show_pagination ? 'true' : 'false'); ?>" data-nav="<?php echo esc_attr($show_nav ? 'true' : 'false'); ?>"
                    data-centerMode="true"
                    <?php echo esc_attr( ($style == 'style2')?'data-centerpadding=260px data-lgcenterpadding=50px data-infinite=true ':'data-centerpadding=0px' );?>
                    >
                    
                    <?php foreach ($amenities as $item) { ?>
                        <div class="item">
                            <div class="item-inner <?php echo esc_attr($style); ?>">
                                
                                <?php
                                $html = '<div class="amenities-box-image">';
                                    $image_html = '';
                                    if ( ! empty( $item['image']['url'] ) ) {
                                        $this->add_render_attribute( 'image', 'src', $item['image']['url'] );
                                        $this->add_render_attribute( 'image', 'alt', Elementor\Control_Media::get_image_alt( $item['image'] ) );
                                        $this->add_render_attribute( 'image', 'title', Elementor\Control_Media::get_image_title( $item['image'] ) );


                                        $image_html = Elementor\Group_Control_Image_Size::get_attachment_image_html( $item, 'thumbnail', 'image' );

                                        if ( ! empty( $item['link']['url'] ) ) {
                                            $image_html = '<a href="'.esc_url($item['link']['url']).'" target="'.esc_attr($item['link']['is_external'] ? '_blank' : '_self').'" '.($item['link']['nofollow'] ? 'rel="nofollow"' : '').'>' . $image_html . '</a>';
                                        }

                                        $html .= '<div class="clearfix img">' . $image_html . '</div>';
                                    }
                                    
                                $html .= '</div>';

                                if ( ! empty( $item['title_text'] ) || ! empty( $item['description_text'] ) ) {
                                    $html .= '<div class="amenities-box-content">';

                                    $html .= '<div class="clearfix"><div class="amenities-box-icon"><i class="'.$item['icon'].'"></i></div></div>';

                                    if ( ! empty( $item['title_text'] ) ) {
                                        
                                        if ( ! empty( $item['link']['url'] ) ) {
                                            $html .= '<a href="'.esc_url($item['link']['url']).'" target="'.esc_attr($item['link']['is_external'] ? '_blank' : '_self').'" '.($item['link']['nofollow'] ? 'rel="nofollow"' : '').'><h3 class="title">'.$item['title_text'].'</h3></a>';
                                        } else {
                                            $html .= sprintf( '<h3 class="title">%1$s</h3>', $item['title_text'] );
                                        }
                                    }

                                    if ( ! empty( $item['description_text'] ) ) {
                                        $html .= sprintf( '<div class="description">%1$s</div>', $item['description_text'] );
                                    }

                                    $html .= '</div>';
                                }

                                echo trim($html);
                                ?>

                            </div>
                        </div>
                    <?php } ?>
                       
                </div>
            </div>
            <?php
        }
    }

}

Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Qxygen_Elementor_Amenities );