<?php

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Qxygen_Elementor_Availability extends Elementor\Widget_Base {

	public function get_name() {
        return 'apus_element_availability';
    }

	public function get_title() {
        return esc_html__( 'Apus Availability', 'qxygen' );
    }

	public function get_icon() {
        return 'eicon-bullet-list';
    }

	public function get_categories() {
        return [ 'qxygen-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Availability', 'qxygen' ),
                'tab' => Elementor\Controls_Manager::TAB_CONTENT,
            ]
        );
        
        $repeater = new Elementor\Repeater();


        $repeater->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'qxygen' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'default' => esc_html__( 'This is the heading', 'qxygen' ),
                'placeholder' => esc_html__( 'Enter your title', 'qxygen' ),
            ]
        );

        $repeater->add_control(
            'value',
            [
                'label' => esc_html__( 'Value', 'qxygen' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Enter your value', 'qxygen' ),
            ]
        );


        $this->add_control(
            'image',
            [
                'label' => esc_html__( 'Choose Image', 'qxygen' ),
                'type' => Elementor\Controls_Manager::MEDIA,
                'dynamic' => [
                    'active' => true,
                ],
                'default' => [
                    'url' => Elementor\Utils::get_placeholder_image_src(),
                ],
            ]
        );

        $this->add_group_control(
            Elementor\Group_Control_Image_Size::get_type(),
            [
                'name' => 'image', // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `thumbnail_size` and `thumbnail_custom_dimension`.
                'exclude' => [ 'custom' ],
                'separator' => 'none',
                'default' => 'full'
            ]
        );

        $this->add_control(
            'items',
            [
                'label' => esc_html__( 'Amenity Items', 'qxygen' ),
                'type' => Elementor\Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        $this->add_control(
            'btn_text',
            [
                'label' => esc_html__( 'Button Text', 'qxygen' ),
                'type' => Elementor\Controls_Manager::TEXT,
                'default' => 'View',
                'placeholder' => esc_html__( 'Enter your button text', 'qxygen' ),
            ]
        );

   		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'qxygen' ),
                'type'          => Elementor\Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'qxygen' ),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_box_style',
            [
                'label' => esc_html__( 'Style', 'qxygen' ),
                'tab' => Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'background',
                'label' => esc_html__( 'Background', 'qxygen' ),
                'types' => [ 'classic', 'gradient', 'video' ],
                'selector' => '{{WRAPPER}} .widget-availability',
            ]
        );

        $this->add_group_control(
            Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'border',
                'label' => esc_html__( 'Border', 'qxygen' ),
                'selector' => '{{WRAPPER}} .widget-availability',
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'section_header_style',
            [
                'label' => esc_html__( 'Header', 'qxygen' ),
                'tab' => Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Elementor\Group_Control_Background::get_type(),
            [
                'name' => 'image_background',
                'label' => esc_html__( 'Background', 'qxygen' ),
                'types' => [ 'classic', 'gradient' ],
                'selector' => '{{WRAPPER}} .banner-image',
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'section_content_style',
            [
                'label' => esc_html__( 'Content', 'qxygen' ),
                'tab' => Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Title', 'qxygen' ),
                'type' => Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .title' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'value_color',
            [
                'label' => esc_html__( 'Value', 'qxygen' ),
                'type' => Elementor\Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .value' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'section_button_style',
            [
                'label' => esc_html__( 'Button', 'qxygen' ),
                'tab' => Elementor\Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs(
            'style_tabs'
        );

            $this->start_controls_tab(
                'style_normal_tab',
                [
                    'label' => esc_html__( 'Normal', 'qxygen' ),
                ]
            );

            $this->add_control(
                'button_color',
                [
                    'label' => esc_html__( 'Color', 'qxygen' ),
                    'type' => Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        // Stronger selector to avoid section style from overwriting
                        '{{WRAPPER}} .btn-view' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_group_control(
                Elementor\Group_Control_Background::get_type(),
                [
                    'name' => 'button_background',
                    'label' => esc_html__( 'Background', 'qxygen' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .btn-view',
                ]
            );

            $this->end_controls_tab();


            $this->start_controls_tab(
                'style_hover_tab',
                [
                    'label' => esc_html__( 'Hover', 'qxygen' ),
                ]
            );

            $this->add_control(
                'button_hv_color',
                [
                    'label' => esc_html__( 'Color', 'qxygen' ),
                    'type' => Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        // Stronger selector to avoid section style from overwriting
                        '{{WRAPPER}} .widget-availability:hover .btn-view' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_group_control(
                Elementor\Group_Control_Background::get_type(),
                [
                    'name' => 'button_hv_background',
                    'label' => esc_html__( 'Background', 'qxygen' ),
                    'types' => [ 'classic', 'gradient' ],
                    'selector' => '{{WRAPPER}} .widget-availability:hover .btn-view',
                ]
            );

            $this->add_control(
                'button_hv_br_color',
                [
                    'label' => esc_html__( 'Border Color', 'qxygen' ),
                    'type' => Elementor\Controls_Manager::COLOR,
                    'selectors' => [
                        // Stronger selector to avoid section style from overwriting
                        '{{WRAPPER}} .widget-availability:hover .btn-view' => 'border-color: {{VALUE}};',
                    ],
                    'condition' => [
                        'border_button_border!' => '',
                    ],
                ]
            );   

            $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_group_control(
            Elementor\Group_Control_Border::get_type(),
            [
                'name' => 'border_button',
                'label' => esc_html__( 'Border', 'qxygen' ),
                'selector' => '{{WRAPPER}} .btn-view',
            ]
        );

        $this->end_controls_section();

    }

	protected function render() {
        $settings = $this->get_settings();

        extract( $settings );
        $_id = qxygen_random_key();

        if ( $image_size == 'custom' ) {
            if ( $image_custom_dimension['width'] && $image_custom_dimension['height'] ) {
                $thumbsize = $image_custom_dimension['width'].'x'.$image_custom_dimension['height'];
            } else {
                $thumbsize = 'full';
            }
        } else {
            $thumbsize = $image_size;
        }
        ?>
        <div class="widget-availability <?php echo esc_attr($el_class); ?>">
            <?php
            if ( !empty($image['id']) ) {
            ?>

                <div class="banner-image">
                    <?php echo qxygen_get_attachment_thumbnail($image['id'], $thumbsize); ?>
                </div>

            <?php } ?>
            <div class="inner">
                <?php if ( !empty($items) ) { ?>
                    <ul class="list">
                        <?php foreach ($items as $item) { ?>
                            <li>
                                <span class="title"><?php echo esc_html(!empty($item['title']) ? $item['title'] : ''); ?></span>
                                <span class="value"><?php echo esc_html(!empty($item['value']) ? $item['value'] : ''); ?></span>
                            </li>
                        <?php } ?>
                    </ul>
                <?php } ?>

                <?php if ( !empty($btn_text) ) { ?>
                    <div class="more-bottom">
                        <a class="btn-block btn btn-view" href="<?php echo esc_url($image['url']); ?>" data-elementor-lightbox-slideshow="gallery-<?php echo esc_attr($_id); ?>"><?php echo esc_html($btn_text); ?></a>
                    </div>
                <?php } ?>
            </div>
        </div>
        <?php
    }
}

Elementor\Plugin::instance()->widgets_manager->register_widget_type( new Qxygen_Elementor_Availability );