<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Qxygen_Elementor_Gallery extends Widget_Base {

    public function get_name() {
        return 'apus_element_gallery';
    }

    public function get_title() {
        return esc_html__( 'Apus Gallery', 'qxygen' );
    }
    
    public function get_categories() {
        return [ 'qxygen-elements' ];
    }

    protected function register_controls() {

        $repeater = new Repeater();

        $repeater->add_control(
            'filter_title',
            [
                'label'       => esc_html__('Filter Title', 'qxygen'),
                'type'        => Controls_Manager::TEXT,
                'label_block' => true,
                'placeholder' => esc_html__('List Item', 'qxygen'),
                'default'     => esc_html__('List Item', 'qxygen'),
            ]
        );

        $repeater->add_control(
            'wp_gallery',
            [
                'label'      => esc_html__('Add Images', 'qxygen'),
                'type'       => Controls_Manager::GALLERY,
                'show_label' => false,
                'dynamic'    => [
                    'active' => true,
                ],
            ]
        );

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Gallery', 'qxygen' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'filter',
            [
                'label'       => '',
                'type'        => Controls_Manager::REPEATER,
                'fields'      => $repeater->get_controls(),
                'default'     => [
                    [
                        'filter_title' => esc_html__('Gallery 1', 'qxygen'),
                    ],
                ],
                'title_field' => '{{{ filter_title }}}',
            ]
        );

        $this->add_group_control(
            Group_Control_Image_Size::get_type(),
            [
                'name' => 'image', // Usage: `{name}_size` and `{name}_custom_dimension`, in this case `thumbnail_size` and `thumbnail_custom_dimension`.
                'exclude' => [ 'custom' ],
                'separator' => 'none',
            ]
        );

        $columns = range( 1, 10 );
        $columns = array_combine( $columns, $columns );

        $this->add_control(
            'columns',
            [
                'label' => esc_html__( 'Columns', 'qxygen' ),
                'type' => Controls_Manager::SELECT,
                'default' => 4,
                'options' => $columns,
                'condition' => [
                    'layout_type' => ['carousel', 'grid'],
                ],
            ]
        );

        $this->add_control(
            'layout_type',
            [
                'label' => esc_html__( 'Layout Type', 'qxygen' ),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    'grid' => esc_html__('Grid', 'qxygen'),
                    'carousel' => esc_html__('Carousel', 'qxygen'),
                    'mansory' => esc_html__('Mansory', 'qxygen'),
                ),
                'default' => 'grid'
            ]
        );

        $this->add_control(
            'rows',
            [
                'label' => esc_html__( 'Rows', 'qxygen' ),
                'type' => Controls_Manager::TEXT,
                'input_type' => 'number',
                'placeholder' => esc_html__( 'Enter your rows number here', 'qxygen' ),
                'default' => 1,
                'condition' => [
                    'layout_type' => 'carousel',
                ],
            ]
        );

        $this->add_control(
            'show_nav',
            [
                'label'         => esc_html__( 'Show Navigation', 'qxygen' ),
                'type'          => Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Show', 'qxygen' ),
                'label_off'     => esc_html__( 'Hide', 'qxygen' ),
                'return_value'  => true,
                'default'       => true,
                'condition' => [
                    'layout_type' => 'carousel',
                ],
            ]
        );

        $this->add_control(
            'show_pagination',
            [
                'label'         => esc_html__( 'Show Pagination', 'qxygen' ),
                'type'          => Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Show', 'qxygen' ),
                'label_off'     => esc_html__( 'Hide', 'qxygen' ),
                'return_value'  => true,
                'default'       => true,
                'condition' => [
                    'layout_type' => 'carousel',
                ],
            ]
        );

        $this->add_control(
            'autoplay',
            [
                'label'         => esc_html__( 'Autoplay', 'qxygen' ),
                'type'          => Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Yes', 'qxygen' ),
                'label_off'     => esc_html__( 'No', 'qxygen' ),
                'return_value'  => true,
                'default'       => true,
                'condition' => [
                    'layout_type' => 'carousel',
                ],
            ]
        );

        $this->add_control(
            'infinite_loop',
            [
                'label'         => esc_html__( 'Infinite Loop', 'qxygen' ),
                'type'          => Controls_Manager::SWITCHER,
                'label_on'      => esc_html__( 'Yes', 'qxygen' ),
                'label_off'     => esc_html__( 'No', 'qxygen' ),
                'return_value'  => true,
                'default'       => true,
                'condition' => [
                    'layout_type' => 'carousel',
                ],
            ]
        );

        $this->add_control(
            'style',
            [
                'label' => esc_html__( 'Style', 'qxygen' ),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    '' => esc_html__('Default', 'qxygen'),
                    'style1' => esc_html__('Style 1', 'qxygen'),
                ),
                'default' => ''
            ]
        );

        $this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'qxygen' ),
                'type'          => Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'qxygen' ),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_style_style',
            [
                'label' => esc_html__( 'Style Tab', 'qxygen' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->start_controls_tabs(
            'style_tabs'
        );

            $this->start_controls_tab(
                'style_normal_tab',
                [
                    'label' => esc_html__( 'Normal', 'qxygen' ),
                ]
            );

            $this->add_control(
                'color',
                [
                    'label' => esc_html__( 'Color', 'qxygen' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        // Stronger selector to avoid section style from overwriting
                        '{{WRAPPER}} .tab-gallery li a' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->end_controls_tab();


            $this->start_controls_tab(
                'style_hover_tab',
                [
                    'label' => esc_html__( 'Hover', 'qxygen' ),
                ]
            );

            $this->add_control(
                'hover_color',
                [
                    'label' => esc_html__( 'Color', 'qxygen' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        // Stronger selector to avoid section style from overwriting
                        '{{WRAPPER}} .tab-gallery li.active a' => 'color: {{VALUE}};',
                    ],
                ]
            );

            $this->add_control(
                'line_color',
                [
                    'label' => esc_html__( 'Color', 'qxygen' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        // Stronger selector to avoid section style from overwriting
                        '{{WRAPPER}} .tab-gallery li a::before' => 'background-color: {{VALUE}};',
                    ],
                ]
            );

            $this->end_controls_tab();

        $this->end_controls_tabs();


        $this->end_controls_section();

        $this->start_controls_section(
            'section_content_style',
            [
                'label' => esc_html__( 'Style Content', 'qxygen' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_control(
            'overlay_color',
            [
                'label' => esc_html__( 'Color Overlay', 'qxygen' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .widget-gallery .click-active::before' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'button_color',
            [
                'label' => esc_html__( 'Color Button', 'qxygen' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .widget-gallery .gallery-item-overlay' => 'color: {{VALUE}};',
                ],
            ]
        );
        $this->add_control(
            'button_bg_color',
            [
                'label' => esc_html__( 'Background Color Button', 'qxygen' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .widget-gallery .gallery-item-overlay' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();

    }

    protected function render() {

        $settings = $this->get_settings();

        extract( $settings );

        if ( $image_size == 'custom' ) {
            if ( $image_custom_dimension['width'] && $image_custom_dimension['height'] ) {
                $thumbsize = $image_custom_dimension['width'].'x'.$image_custom_dimension['height'];
            } else {
                $thumbsize = 'full';
            }
        } else {
            $thumbsize = $image_size;
        }
        $classes = '';
        if ( Plugin::$instance->editor->is_edit_mode() ) {
            $classes = 'elementor-clickable';
        }
        $rand = qxygen_random_key();

        $image_gallery = array();
        foreach ($settings['filter'] as $index => $item) {
            if (!empty($item['wp_gallery'])) {
                foreach ($item['wp_gallery'] as $items => $attachment) {
                    // $attachment['group'] = $index;
                    // $image_gallery[] = $attachment;
                    if ( isset($image_gallery[$attachment['id']]) ) {
                        $image_gallery[$attachment['id']]['classes'][] = 'gallery_group_'.$index;
                    } else {
                        $attachment['classes'] = array('gallery_group_'.$index);
                        $image_gallery[$attachment['id']] = $attachment;
                    }
                }
            }
        }
        ?>
        <div class="widget-gallery <?php echo esc_attr($el_class.' '.$layout_type.' '.$style); ?>">
            
            <div class="inner">
                <?php if ( $layout_type == 'carousel' ) {
                    $show_nav = isset($show_nav) ? $show_nav : false;
                    $show_pagination = isset($show_pagination) ? $show_pagination : false;
                    $rows = isset($rows) ? $rows : 1;
                    $columns = isset($columns) ? $columns : 3;
                    $small_cols = $columns <= 1 ? 1 : 2;
                    $smalldesktop_cols = $columns >= 5 ? 4 : $columns;
                ?>
                    <div class="slick-carousel" data-carousel="slick" data-items="<?php echo esc_attr($columns); ?>"
                        data-large="<?php echo esc_attr($smalldesktop_cols); ?>"
                        data-smallmedium="<?php echo esc_attr($small_cols); ?>"
                        data-extrasmall="1"
                        data-pagination="<?php echo esc_attr( $show_pagination ? 'true' : 'false' ); ?>"
                        data-nav="<?php echo esc_attr( $show_nav ? 'true' : 'false' ); ?>"
                        data-rows="<?php echo esc_attr( $rows ); ?>" data-infinite="<?php echo esc_attr( $infinite_loop ? 'true' : 'false' ); ?>"
                        data-autoplay="<?php echo esc_attr( $autoplay ? 'true' : 'false' ); ?>">

                        <?php foreach ( $image_gallery as $item ) {
                            $image_url_full = wp_get_attachment_image_url($item['id'], 'full');
                        ?>
                            <a href="<?php echo esc_url($image_url_full); ?>" class="click-active <?php echo esc_attr($classes); ?>" data-elementor-lightbox-slideshow="gallery-<?php echo esc_attr($rand); ?>">
                                <?php echo qxygen_get_attachment_thumbnail($item['id'], $thumbsize); ?>
                                <span class="gallery-item-overlay">
                                    <i class="fas fa-search-plus"></i>
                                </span>
                            </a>
                        <?php } ?>

                    </div>
                <?php } elseif ( $layout_type == 'mansory' ) {
                    wp_enqueue_script( 'isotope-pkgd', get_template_directory_uri().'/js/isotope.pkgd.min.js', array( 'jquery', 'imagesloaded' ) );
                    // $bcol = floor( 12 / $columns );
                    $col_classes = 'col-md-4';

                    ?>
                        <ul class="isotope-filter tab-gallery" data-related-grid="filter-isotope-<?php echo esc_attr($rand); ?>">
                            <li class="active">
                                <a href="javascript:void(0);" data-filter=".gallery_group_all"><?php esc_html_e('All', 'qxygen'); ?></a>
                            </li>
                            <?php foreach ($settings['filter'] as $key => $term) { ?>
                                <li>
                                    <a href="javascript:void(0);" data-filter=".gallery_group_<?php echo esc_attr($key); ?>"><?php echo esc_html($term['filter_title']); ?></a>
                                </li>
                            <?php } ?>
                        </ul>
                        <div id="filter-isotope-<?php echo esc_attr($rand); ?>" class="isotope-items row" data-isotope-duration="400" data-columnwidth=".<?php echo esc_attr($col_classes); ?>">

                            <?php $i=1; foreach ( $image_gallery as $item ) {
                                $image_url_full = wp_get_attachment_image_url($item['id'], 'full');
                                $bcol_classes = $col_classes;
                                $bthumbsize = $thumbsize;
                            ?>
                                <div class="item-vertical isotope-item col-sm-6 <?php echo esc_attr($bcol_classes); ?> col-xs-6 gallery_group_all <?php echo esc_attr(implode(' ', $item['classes'])); ?>">
                                    <a href="<?php echo esc_url($image_url_full); ?>" class="click-active <?php echo esc_attr($classes); ?>" data-elementor-lightbox-slideshow="gallery-<?php echo esc_attr($rand); ?>">
                                        <?php echo qxygen_get_attachment_thumbnail($item['id'], $bthumbsize); ?>
                                        <span class="gallery-item-overlay">
                                            <i class="fas fa-search-plus"></i>
                                        </span>
                                    </a>
                                </div>
                            <?php $i++; } ?>

                        </div>
                    <?php
                } else {
                    $bcol = 12/$columns;
                    ?>
                    <div class="row">
                        <?php foreach ( $image_gallery as $item ) {
                            $image_url_full = wp_get_attachment_image_url($item['id'], 'full');
                        ?>
                            <div class="item-vertical col-md-<?php echo esc_attr($bcol); ?> col-sm-4 col-xs-6">
                                <a href="<?php echo esc_url($image_url_full); ?>" class="click-active <?php echo esc_attr($classes); ?>" data-elementor-lightbox-slideshow="gallery-<?php echo esc_attr($rand); ?>">
                                    <?php echo qxygen_get_attachment_thumbnail($item['id'], $thumbsize); ?>
                                    <span class="gallery-item-overlay">
                                        <i class="fas fa-search-plus"></i>
                                    </span>
                                </a>
                            </div>
                        <?php } ?>
                    </div>
                    <?php
                } ?>
            </div>
        </div>
        <?php

    }
}

Plugin::instance()->widgets_manager->register_widget_type( new Qxygen_Elementor_Gallery );