<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Qxygen_Elementor_List_Info extends Widget_Base {

    public function get_name() {
        return 'apus_element_list_info';
    }

    public function get_title() {
        return esc_html__( 'Apus List Info', 'qxygen' );
    }

    public function get_icon() {
        return 'eicon-bullet-list';
    }

    public function get_categories() {
        return [ 'qxygen-elements' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'List Info', 'qxygen' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'title',
            [
                'label' => esc_html__( 'title', 'qxygen' ),
                'type' => Controls_Manager::TEXT,
            ]
        );
        $repeater->add_control(
            'value',
            [
                'label' => esc_html__( 'Value', 'qxygen' ),
                'type' => Controls_Manager::TEXT,
            ]
        );

        $this->add_control(
            'items',
            [
                'label' => esc_html__( 'Items', 'qxygen' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );
        
        $this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'qxygen' ),
                'type'          => Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'qxygen' ),
            ]
        );

        $this->end_controls_section();
        
        $this->start_controls_section(
            'section_box_style',
            [
                'label' => esc_html__( 'Style', 'qxygen' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_responsive_control(
            'li_padding',
            [
                'label' => esc_html__( 'Padding Line', 'qxygen' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .list-info li' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
            ]
        );

        $this->add_control(
            'title_color',
            [
                'label' => esc_html__( 'Color Heading Info', 'qxygen' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .heading-info' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'value_color',
            [
                'label' => esc_html__( 'Color Value', 'qxygen' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .ali-right' => 'color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'bg_color',
            [
                'label' => esc_html__( 'Background Color', 'qxygen' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .list-info li' => 'background-color: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'br_color',
            [
                'label' => esc_html__( 'Border Color', 'qxygen' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .list-info li' => 'border-color: {{VALUE}};',
                ],
            ]
        );

        $this->end_controls_section();
    }

    protected function render() {
        $settings = $this->get_settings();

        extract( $settings );

        if ( !empty($items) ) {
            ?>
            <div class="widget-list-info <?php echo esc_attr($el_class); ?>">
                <ul class="list-info">
                    <?php foreach ($items as $item): ?>
                        <?php if ( $item['title'] ) { ?>
                            <li><span class="heading-info"><?php echo trim($item['title']); ?></span><span class="ali-right"><?php echo trim($item['value']); ?></span></li>
                        <?php } ?>
                    <?php endforeach; ?>
                </ul>
            </div>
            <?php
        }
    }
}

Plugin::instance()->widgets_manager->register_widget_type( new Qxygen_Elementor_List_Info );