<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Qxygen_Elementor_Maps extends Widget_Base {

	public function get_name() {
        return 'apus_element_maps';
    }

	public function get_title() {
        return esc_html__( 'Apus Maps', 'qxygen' );
    }

    public function get_icon() {
        return 'eicon-google-maps';
    }

	public function get_categories() {
        return [ 'qxygen-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Maps', 'qxygen' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();

        $repeater->add_control(
            'title', [
                'label' => esc_html__( 'Title', 'qxygen' ),
                'type' => Controls_Manager::TEXT,
                'label_block' => true,
            ]
        );

        $repeater->add_control(
            'image',
            [
                'label' => esc_html__( 'Image', 'qxygen' ),
                'type' => Controls_Manager::MEDIA,
                'placeholder'   => esc_html__( 'Upload Image Here', 'qxygen' ),
            ]
        );

        $repeater->add_control(
            'latitude', [
                'label' => esc_html__( 'Latitude', 'qxygen' ),
                'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Enter latitude here' , 'qxygen' ),
            ]
        );

        $repeater->add_control(
            'longitude', [
                'label' => esc_html__( 'Longitude', 'qxygen' ),
                'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Enter longitude here' , 'qxygen' ),
            ]
        );
        
        $this->add_control(
            'pins',
            [
                'label' => esc_html__( 'Pins', 'qxygen' ),
                'type' => Controls_Manager::REPEATER,
                'fields' => $repeater->get_controls(),
            ]
        );

        $this->add_control(
            'height', [
                'label' => esc_html__( 'Height', 'qxygen' ),
                'type' => Controls_Manager::TEXT,
                'default' => '400',
            ]
        );

   		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'qxygen' ),
                'type'          => Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'qxygen' ),
            ]
        );

        $this->end_controls_section();
    }

	protected function render() {
        $settings = $this->get_settings();

        extract( $settings );

        
        // maps
        $key = qxygen_get_config('google_map_api_key');
        wp_enqueue_script('google-api', '//maps.google.com/maps/api/js?key='.$key );
        wp_enqueue_script('leaflet', get_template_directory_uri().'/js/leaflet.js');
        wp_register_script('qxygen-maps', get_template_directory_uri().'/js/maps.js');
        $mapbox_token = '';
        $mapbox_style = '';
        $custom_style = '';
        $map_service = qxygen_get_config('map_service_type', '');
        if ( $map_service == 'mapbox' ) {
            $mapbox_token = qxygen_get_config('mapbox_token', '');

            $mapbox_style = qxygen_get_config('mapbox_style', 'light-v10');
            if ( empty($mapbox_style) || !in_array($mapbox_style, array( 'streets-v11', 'light-v10', 'dark-v10', 'outdoors-v11', 'satellite-v9' )) ) {
                $mapbox_style = 'light-v10';
            }
        } else {
            $custom_style = qxygen_get_config('google_map_style', '');
        }
        wp_localize_script( 'qxygen-maps', 'qxygen_maps_opts', array(
            'map_service' => $map_service,
            'mapbox_token' => $mapbox_token,
            'mapbox_style' => $mapbox_style,
            'custom_style' => $custom_style,
            'default_icon' => get_template_directory_uri() . '/images/default-icon.png',
        ) );
        wp_enqueue_script('qxygen-maps');
        wp_enqueue_style( 'leaflet', get_template_directory_uri() . '/css/leaflet.css', array(), '1.8.0' );

        ?>
        <div class="widget-maps <?php echo esc_attr($el_class); ?>">
            <?php if ( $pins ) { ?>
                <div class="hidden maps-pins-wrapper">
                    <?php foreach ($pins as $pin) { ?>
                        <div class="maps-pin-item" data-latitude="<?php echo esc_attr(!empty($pin['latitude']) ? $pin['latitude'] : ''); ?>" data-longitude="<?php echo esc_attr(!empty($pin['longitude']) ? $pin['longitude'] : ''); ?>">
                            <div class="pin-content-wrtapper">
                                <?php
                                if ( !empty($pin['image']['id']) ) {
                                ?>
                                    <div class="pin-image">
                                        <?php echo wp_get_attachment_image($pin['image']['id'], 'full'); ?>
                                    </div>
                                <?php } ?>
                                <?php if ( !empty($pin['title']) ) { ?>
                                    <h3 class="pin-title"><?php echo esc_html($pin['title']); ?></h3>
                                <?php } ?>
                            </div>
                        </div>
                    <?php } ?>
                </div>
            <?php } ?>
            <div id="widget-maps-init" class="widget-maps-init" style="height: <?php echo esc_attr($height); ?>px;"></div>
        </div>
        <?php
    }

}

Plugin::instance()->widgets_manager->register_widget_type( new Qxygen_Elementor_Maps );