<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Qxygen_Elementor_Process extends Widget_Base {

	public function get_name() {
        return 'apus_element_process';
    }

	public function get_title() {
        return esc_html__( 'Apus Process', 'qxygen' );
    }

	public function get_categories() {
        return [ 'qxygen-elements' ];
    }

    protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Process', 'qxygen' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );
        $this->add_control(
            'title',
            [
                'label' => esc_html__( 'Title', 'qxygen' ),
                'type' => Controls_Manager::TEXT,
                'input_type' => 'text',
                'placeholder' => esc_html__( 'Enter your title here', 'qxygen' ),
            ]
        );

        $this->add_control(
            'content',
            [
                'label' => esc_html__( 'Content', 'qxygen' ),
                'type' => Controls_Manager::WYSIWYG,
                'placeholder' => esc_html__( 'Enter your content here', 'qxygen' ),
            ]
        );

        $this->add_control(
            'percent',
            [
                'label' => esc_html__( 'Percent (%)', 'qxygen' ),
                'type' => Controls_Manager::TEXT,
                'input_type' => 'number',
                'default' => '50'
            ]
        );

        $this->add_control(
            'style',
            [
                'label' => esc_html__( 'Style', 'qxygen' ),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    'style1' => esc_html__('Style 1', 'qxygen'),
                    'style2' => esc_html__('Style 2', 'qxygen'),
                ),
                'default' => 'style1'
            ]
        );

        $this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'qxygen' ),
                'type'          => Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'qxygen' ),
            ]
        );

        $this->end_controls_section();


        $this->start_controls_section(
            'section_title_style',
            [
                'label' => esc_html__( 'Style', 'qxygen' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );
        $this->add_control(
            'color1',
            [
                'label' => esc_html__( 'Color 1', 'qxygen' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .description' => 'color: {{VALUE}};',
                ],
                'default' => '#fc5c62'
            ]
        );
        $this->add_control(
            'color2',
            [
                'label' => esc_html__( 'Color 2', 'qxygen' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .description' => 'color: {{VALUE}};',
                ],
                'default' => '#fbb987'
            ]
        );
        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings();
        extract( $settings );

            ?>
            <div class="widget-process <?php echo esc_attr($el_class.' '.$style); ?>">
                <?php if( !empty($title) ) { ?>
                    <h2 class="title" >
                       <?php echo trim( $title ); ?>
                    </h2>
                <?php } ?>
                <?php if($style == 'style1'){ ?>
                    <div class="inner flex justify-content-between">
                        <div class="process-content">
                            <?php if ( !empty($content) ) { ?>
                                <?php echo trim($content); ?>
                            <?php } ?>
                        </div>
                        <?php if(!empty($percent)){ ?>
                            <div class="percent" data-percent="<?php echo trim($percent); ?>" data-color1="<?php echo trim($color1); ?>" data-color2="<?php echo trim($color2); ?>">
                                <canvas class="percent-value"></canvas>
                            </div>
                        <?php } ?>
                    </div>
                <?php }else{ ?>
                    <div class="inner flex-middle">
                        <?php if(!empty($percent)){ ?>
                            <div class="percent" data-percent="<?php echo trim($percent); ?>" data-color1="<?php echo trim($color1); ?>" data-color2="<?php echo trim($color2); ?>">
                                <canvas class="percent-value"></canvas>
                            </div>
                        <?php } ?>
                        <div class="process-content">
                            <?php if ( !empty($content) ) { ?>
                                <?php echo trim($content); ?>
                            <?php } ?>
                        </div>
                    </div>
                <?php } ?>
            </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type( new Qxygen_Elementor_Process );