<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Qxygen_Elementor_Schedule extends Widget_Base {

	public function get_name() {
        return 'apus_element_schedule';
    }

	public function get_title() {
        return esc_html__( 'Apus Schedule Visit', 'qxygen' );
    }
    
	public function get_categories() {
        return [ 'qxygen-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Schedule', 'qxygen' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $this->add_control(
            'btn_text',
            [
                'label' => esc_html__( 'Button Text', 'qxygen' ),
                'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'Enter your button text here', 'qxygen' ),
            ]
        );

        $this->add_responsive_control(
            'content_align',
            [
                'label' => esc_html__( 'Content Alignment', 'qxygen' ),
                'type' => Controls_Manager::CHOOSE,
                'options' => [
                    'left' => [
                        'title' => esc_html__( 'Left', 'qxygen' ),
                        'icon' => 'fa fa-align-left',
                    ],
                    'center' => [
                        'title' => esc_html__( 'Center', 'qxygen' ),
                        'icon' => 'fa fa-align-center',
                    ],
                    'right' => [
                        'title' => esc_html__( 'Right', 'qxygen' ),
                        'icon' => 'fa fa-align-right',
                    ],
                    'justify' => [
                        'title' => esc_html__( 'Justified', 'qxygen' ),
                        'icon' => 'fa fa-align-justify',
                    ],
                ],
                'default' => '',
                'selectors' => [
                    '{{WRAPPER}}' => 'text-align: {{VALUE}};',
                ],
            ]
        );

        $this->add_control(
            'style',
            [
                'label' => esc_html__( 'Style', 'qxygen' ),
                'type' => Controls_Manager::SELECT,
                'options' => array(
                    'st_normal' => esc_html__('Line Under 1', 'qxygen'),
                    'st_line2' => esc_html__('Line Under 2', 'qxygen'),
                    'st_button' => esc_html__('Button', 'qxygen'),
                ),
                'default' => 'st_normal'
            ]
        );


   		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'qxygen' ),
                'type'          => Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'qxygen' ),
            ]
        );

        $this->end_controls_section();

        $this->start_controls_section(
            'section_button',
            [
                'label' => esc_html__( 'Style Button', 'qxygen' ),
                'tab' => Controls_Manager::TAB_STYLE,
            ]
        );

        $this->add_group_control(
            Group_Control_Typography::get_type(),
            [
                'label' => esc_html__( 'Title Typography', 'qxygen' ),
                'name' => 'title_typography',
                'selector' => '{{WRAPPER}} .text-underline,{{WRAPPER}} .btn',
            ]
        );

        $this->add_control(
            'button_color',
            [
                'label' => esc_html__( 'Color', 'qxygen' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .text-underline' => 'color: {{VALUE}};',
                ],
                'condition' => [
                    'style' => [ 'st_normal', 'st_line2' ],
                ],
            ]
        );
        $this->add_control(
            'line_color',
            [
                'label' => esc_html__( 'Line Color', 'qxygen' ),
                'type' => Controls_Manager::COLOR,
                'selectors' => [
                    // Stronger selector to avoid section style from overwriting
                    '{{WRAPPER}} .text-underline:before ' => 'background-color: {{VALUE}};',
                ],
                'condition' => [
                    'style' => [ 'st_normal', 'st_line2' ],
                ],
            ]
        );

        $this->start_controls_tabs( 'tabs_button_style' );

            $this->start_controls_tab(
                'tab_button_normal',
                [
                    'label' => esc_html__( 'Normal', 'qxygen' ),
                    'condition' => [
                        'style' => 'st_button',
                    ],
                ]
            );

            $this->add_control(
                'button_text_color',
                [
                    'label' => esc_html__( 'Text Color', 'qxygen' ),
                    'type' => Controls_Manager::COLOR,
                    'default' => '',
                    'selectors' => [
                        '{{WRAPPER}} .btn' => 'color: {{VALUE}};',
                    ],
                    'condition' => [
                        'style' => 'st_button',
                    ],
                ]
            );

            $this->add_control(
                'background_color',
                [
                    'label' => esc_html__( 'Background Color', 'qxygen' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .btn' => 'background-color: {{VALUE}};',
                    ],
                    'condition' => [
                        'style' => 'st_button',
                    ],
                ]
            );

            $this->end_controls_tab();

            $this->start_controls_tab(
                'tab_button_hover',
                [
                    'label' => esc_html__( 'Hover', 'qxygen' ),
                    'condition' => [
                        'style' => 'st_button',
                    ],
                ]
            );

            $this->add_control(
                'hover_color',
                [
                    'label' => esc_html__( 'Text Color', 'qxygen' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .btn:hover, {{WRAPPER}} .btn:focus' => 'color: {{VALUE}};',
                    ],
                    'condition' => [
                        'style' => 'st_button',
                    ],
                ]
            );

            $this->add_control(
                'button_background_hover_color',
                [
                    'label' => esc_html__( 'Background Color', 'qxygen' ),
                    'type' => Controls_Manager::COLOR,
                    'selectors' => [
                        '{{WRAPPER}} .btn:hover, {{WRAPPER}} .btn:focus' => 'background-color: {{VALUE}};',
                    ],
                    'condition' => [
                        'style' => 'st_button',
                    ],
                ]
            );

            $this->add_control(
                'button_hover_border_color',
                [
                    'label' => esc_html__( 'Border Color', 'qxygen' ),
                    'type' => Controls_Manager::COLOR,
                    'condition' => [
                        'border_border!' => '',
                    ],
                    'selectors' => [
                        '{{WRAPPER}} .btn:hover, {{WRAPPER}} .btn:focus' => 'border-color: {{VALUE}};',
                    ],
                ]
            );

            $this->end_controls_tab();

        $this->end_controls_tabs();

        $this->add_group_control(
            Group_Control_Border::get_type(),
            [
                'name' => 'border',
                'selector' => '{{WRAPPER}} .btn',
                'separator' => 'before',
                'condition' => [
                    'style' => 'st_button',
                ],
            ]
        );

        $this->add_control(
            'border_radius',
            [
                'label' => esc_html__( 'Border Radius', 'qxygen' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .btn' => 'border-radius: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'condition' => [
                    'style' => 'st_button',
                ],
            ]
        );

        $this->add_responsive_control(
            'button_padding',
            [
                'label' => esc_html__( 'Padding', 'qxygen' ),
                'type' => Controls_Manager::DIMENSIONS,
                'size_units' => [ 'px', 'em', '%' ],
                'selectors' => [
                    '{{WRAPPER}} .btn' => 'padding: {{TOP}}{{UNIT}} {{RIGHT}}{{UNIT}} {{BOTTOM}}{{UNIT}} {{LEFT}}{{UNIT}};',
                ],
                'separator' => 'before',
                'condition' => [
                    'style' => 'st_button',
                ],
            ]
        );

        $this->end_controls_section();
    }

	protected function render() {

        $settings = $this->get_settings();

        extract( $settings );
        ?>
        <div class="apus-schedule-visit <?php echo esc_attr($el_class.' '.$style); ?>">
            <?php if($style == 'st_button') { ?>
                <?php if ( !empty($btn_text) ) { ?>
                    <a class="btn btn-theme schedule-visit-btn" title="<?php echo esc_attr($btn_text); ?>" href="#apus-schedule-visit-wrapper"><span><?php echo esc_html($btn_text); ?></span></a>
                <?php } ?>
            <?php }else{ ?>
                <?php if ( !empty($btn_text) ) { ?>
                    <a class="text-underline schedule-visit-btn" href="#apus-schedule-visit-wrapper"><?php echo esc_html($btn_text); ?></a>
                <?php } ?>
            <?php } ?>
        </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type( new Qxygen_Elementor_Schedule );