<?php

namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

class Qxygen_Elementor_Team extends Widget_Base {

	public function get_name() {
        return 'apus_element_team';
    }

	public function get_title() {
        return esc_html__( 'Apus Teams', 'qxygen' );
    }

    public function get_icon() {
        return 'fa fa-users';
    }

	public function get_categories() {
        return [ 'qxygen-elements' ];
    }

	protected function register_controls() {

        $this->start_controls_section(
            'content_section',
            [
                'label' => esc_html__( 'Team', 'qxygen' ),
                'tab' => Controls_Manager::TAB_CONTENT,
            ]
        );

        $repeater = new Repeater();

        $this->add_control(
            'name', [
                'label' => esc_html__( 'Member Name', 'qxygen' ),
                'type' => Controls_Manager::TEXT,                
                'placeholder' => esc_html__( 'Member Name' , 'qxygen' ),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'email', [
                'label' => esc_html__( 'Email', 'qxygen' ),
                'type' => Controls_Manager::TEXT,
                'placeholder' => esc_html__( 'info@mywebsite.com' , 'qxygen' ),
                'label_block' => true,
            ]
        );

        $this->add_control(
            'phone', [
                'label' => esc_html__( 'Phone', 'qxygen' ),
                'type' => Controls_Manager::TEXT,                
                'placeholder' => esc_html__( '0123456789', 'qxygen' ),
                'label_block' => true,
            ]
        );
        
        $this->add_control(
            'website_link',
            [
                'label' => esc_html__( 'Link Profile', 'qxygen' ),
                'type' => Controls_Manager::URL,
                'placeholder' => esc_html__( 'https://your-link.com', 'qxygen' ),
                'show_external' => true,
                'default' => [
                    'url' => '',
                    'is_external' => true,
                    'nofollow' => true,
                ],
            ]
        );

        $this->add_control(
            'img_src',
            [
                'name' => 'image',
                'label' => esc_html__( 'Image', 'qxygen' ),
                'type' => Controls_Manager::MEDIA,
                'placeholder'   => esc_html__( 'Upload Image Here', 'qxygen' ),
            ]
        );

   		$this->add_control(
            'el_class',
            [
                'label'         => esc_html__( 'Extra class name', 'qxygen' ),
                'type'          => Controls_Manager::TEXT,
                'placeholder'   => esc_html__( 'If you wish to style particular content element differently, please add a class name to this field and refer to it in your custom CSS file.', 'qxygen' ),
            ]
        );

        $this->end_controls_section();

    }

	protected function render() {

        $settings = $this->get_settings();
        $target = $settings['website_link']['is_external'] ? ' target="_blank"' : '';
        $nofollow = $settings['website_link']['nofollow'] ? ' rel="nofollow"' : '';

        extract( $settings );

        ?>
        <div class="widget-team <?php echo esc_attr($el_class); ?> horizontal">

                <?php
                    if ( !empty($settings['img_src']['id']) ) {
                ?>
                    <div class="team-image">
                        <?php echo qxygen_get_attachment_thumbnail($settings['img_src']['id'], 'full'); ?>
                    </div>
                <?php } ?>
                <div class="content">
                    <?php if ( !empty($name) ) { ?>
                        <h3 class="name-team">
                            <?php echo trim($name); ?>
                        </h3>
                    <?php } ?>

                    <?php if ( !empty($email) ) { ?>
                        <div class="email">                            
                            <a href="mailto:<?php echo trim($email); ?>" target="_top"><?php echo trim($email); ?></a>
                        </div>
                    <?php } ?>

                    <?php if ( !empty($phone) ) { ?>
                        <div class="phone">                            
                            <a href="tel:<?php echo trim($phone); ?>"><?php echo trim($phone); ?></a>
                        </div>
                    <?php } ?>
                </div>
        </div>
        <?php
    }
}

Plugin::instance()->widgets_manager->register_widget_type( new Qxygen_Elementor_Team );