(function($) {
    "use strict";
    
    var map, markers, CustomHtmlIcon;

    
    function ApusThemeMapCore() {
        var self = this;
        self.init();
    };

    ApusThemeMapCore.prototype = {
        /**
         *  Initialize scripts
         */
        init: function() {
            var self = this;

            if ($('#widget-maps-init').length) {
                L.Icon.Default.imagePath = 'wp-content/themes/qxygen/images/';
            }
            setTimeout(function(){
                self.mapInit();
            }, 300);
        },
        mapInit: function() {
            var self = this;

            var $window = $(window);

            if ( !$('#widget-maps-init').length ) {
                return;
            }

            map = L.map('widget-maps-init', {
                scrollWheelZoom: false
            });

            markers = new L.MarkerClusterGroup({
                showCoverageOnHover: false
            });

            CustomHtmlIcon = L.HtmlIcon.extend({
                options: {
                    html: "<div class='map-popup'></div>",
                    iconSize: [24, 24],
                    iconAnchor: [24, 24],
                    popupAnchor: [0, -24]
                }
            });

            $window.on('pxg:refreshmap', function() {
                map._onResize();
                setTimeout(function() {
                    map.fitBounds(markers, {
                        padding: [24, 24]
                    });
                }, 100);
            });

            $window.on('pxg:simplerefreshmap', function() {
                map._onResize();
            });

            if ( qxygen_maps_opts.map_service == 'mapbox' ) {
                var tileLayer = L.tileLayer('https://api.mapbox.com/styles/v1/mapbox/'+qxygen_maps_opts.mapbox_style+'/tiles/{z}/{x}/{y}?access_token='+ qxygen_maps_opts.mapbox_token, {
                    attribution: " &copy;  <a href='https://www.mapbox.com/about/maps/'>Mapbox</a> &copy;  <a href='http://www.openstreetmap.org/copyright'>OpenStreetMap</a> <strong><a href='https://www.mapbox.com/map-feedback/' target='_blank'>Improve this map</a></strong>",
                    maxZoom: 18,
                });
            } else {
                if ( qxygen_maps_opts.custom_style != '' ) {
                    try {
                       var custom_style = $.parseJSON(qxygen_maps_opts.custom_style);
                       var tileLayer = new L.Google('ROADMAP', {}, custom_style );
                    } catch(err) {
                        var tileLayer = new L.Google('ROADMAP');
                    }
                } else {
                    var tileLayer = new L.Google('ROADMAP');
                }
                $('#widget-maps-init').addClass('map--google');
            }

            map.addLayer(tileLayer);

            // check home/archive/single page
            self.updateMakerCards();

        },
        updateMakerCards: function() {
            var self = this;
            var $items = $('#widget-maps-init').closest('.widget-maps').find('.maps-pin-item');
            
            if (!$items.length) {
                return;
            }

            if ( $('#widget-maps-init').length && typeof map !== "undefined") {
                map.removeLayer(markers);
                markers = new L.MarkerClusterGroup({
                    showCoverageOnHover: false
                });
                $items.each(function(i, obj) {
                    self.addMakerToMap($(obj), true);
                });
                map.fitBounds(markers, {
                    padding: [24, 24]
                });

                map.addLayer(markers);
            }
        },
        addMakerToMap: function($item, archive) {
            var map;

            if ( typeof $item.data('latitude') === "undefined" && $item.data('latitude') === "" || typeof $item.data('longitude') === "undefined" || $item.data('longitude') == "") {
                return;
            }

            var mapPinHTML = "<div class='map-popup'><div class='map-popup-box'><div class='pin bounce'></div><div class='pulse'></div></div></div>";
           

            map = L.marker([$item.data('latitude'), $item.data('longitude')], {
                icon: new CustomHtmlIcon({ html: mapPinHTML })
            });

            if (typeof archive !== "undefined") {

                $item.hover(function() {
                    $(map._icon).find('.map-popup').addClass('map-popup-selected');
                }, function() {
                    $(map._icon).find('.map-popup').removeClass('map-popup-selected');
                });

                map.bindPopup($item.html()).openPopup();
            }

            markers.addLayer(map);
        }

    }

    $.apusThemeMapCore = ApusThemeMapCore.prototype;

    $(document).ready(function() {
        // Initialize script
        new ApusThemeMapCore();
    });

})(jQuery);