jQuery(document).ready(function($){
	"use strict";
	var qxygen_upload;
	var qxygen_selector;

	function qxygen_add_file(event, selector) {

		var upload = $(".uploaded-file"), frame;
		var $el = $(this);
		qxygen_selector = selector;

		event.preventDefault();

		// If the media frame already exists, reopen it.
		if ( qxygen_upload ) {
			qxygen_upload.open();
			return;
		} else {
			// Create the media frame.
			qxygen_upload = wp.media.frames.qxygen_upload =  wp.media({
				// Set the title of the modal.
				title: "Select Image",

				// Customize the submit button.
				button: {
					// Set the text of the button.
					text: "Selected",
					// Tell the button not to close the modal, since we're
					// going to refresh the page when the image is selected.
					close: false
				}
			});

			// When an image is selected, run a callback.
			qxygen_upload.on( 'select', function() {
				// Grab the selected attachment.
				var attachment = qxygen_upload.state().get('selection').first();

				qxygen_upload.close();
				qxygen_selector.find('.upload_image').val(attachment.attributes.url).change();
				if ( attachment.attributes.type == 'image' ) {
					qxygen_selector.find('.qxygen_screenshot').empty().hide().prepend('<img src="' + attachment.attributes.url + '">').slideDown('fast');
				}
			});

		}
		// Finally, open the modal.
		qxygen_upload.open();
	}

	function qxygen_remove_file(selector) {
		selector.find('.qxygen_screenshot').slideUp('fast').next().val('').trigger('change');
	}
	
	$('body').on('click', '.qxygen_upload_image_action .remove-image', function(event) {
		qxygen_remove_file( $(this).parent().parent() );
	});

	$('body').on('click', '.qxygen_upload_image_action .add-image', function(event) {
		qxygen_add_file(event, $(this).parent().parent());
	});

});