<?php
    $number = qxygen_get_config('number_apartment_recent', 3);
    $columns = qxygen_get_config('recent_apartment_columns', 3);
    
    $args = array(
        'post_type' => 'apartment',
        'posts_per_page' => $number,
        'post__not_in' => array( get_the_ID() ),
        'orderby' => 'date',
        'order' => 'DESC',
    );
    $loop = new WP_Query( $args );
    if( $loop->have_posts() ):
?>
<div class="recent-apartment">
    <h4 class="title text-center">
        <?php esc_html_e( 'Recent Apartment', 'qxygen' ); ?>
    </h4>
    <div class="recent-apartment-content">
        <div class="slick-carousel" data-carousel="slick" data-smallmedium="2" data-extrasmall="1" data-items="<?php echo esc_attr($columns); ?>" data-pagination="false" data-nav="true">
            <?php while ( $loop->have_posts() ) : $loop->the_post(); ?>
                <div class="item">
                    <?php get_template_part( 'template-apartment/loop/apartment-v2' ); ?>
                </div>
            <?php endwhile; ?>
            <?php wp_reset_postdata(); ?>
        </div>
    </div>
</div>
<?php endif; ?>