<?php
if ( ! defined( 'ABSPATH' ) ) {
	exit;
}
get_header();
$sidebar_configs = qxygen_get_apartment_layout_configs();
global $post;

$style = '';
$thumbnail_url = get_the_post_thumbnail_url($post->ID, 'full');
if ( !empty($thumbnail_url) ) {
    $style = 'style="background-image:url('. $thumbnail_url .');"';
}

qxygen_render_breadcrumbs();
?>

<section id="main-container" class="main-content  <?php echo apply_filters('qxygen_apartment_content_class', 'container');?> inner">
	<?php qxygen_before_content( $sidebar_configs ); ?>
	<div class="row">
		<?php qxygen_display_sidebar_left( $sidebar_configs ); ?>

		<div id="main-content" class="col-sm-12 <?php echo esc_attr($sidebar_configs['main']['class']); ?>">
			<main id="main" class="site-main detail-apartment <?php echo esc_attr( (count($sidebar_configs)>1)?'has-sidebar':'no-sidebar' ); ?>" role="main">

			<?php
				// Start the Loop.
				while ( have_posts() ) : the_post();

					?>

					<?php if(has_post_thumbnail()) { ?>
			            <div class="top-image">
			                <?php
			                    $thumb = qxygen_post_thumbnail('full');
			                    echo trim($thumb);
			                ?>
			            </div>
			        <?php } ?>

					<div class="content-apartment-inner">
						<div class="entry-description">
			                <?php the_content(); ?>
			            </div><!-- /entry-content -->

		                <?php if( qxygen_get_config('show_apartment_social_share', true) ){ ?>
	                        <div class="apartment-sharebox text-center">
	                            <?php get_template_part( 'template-parts/sharebox' ); ?>
	                        </div>
	                    <?php } ?>

			            <?php
			                //Previous/next post navigation.
			                the_post_navigation( array(
			                    'next_text' => '<span class="meta-nav"><i class="flaticon-next-1"></i></span> ' .
			                        '<div class="inner">'.
			                        '<div class="navi">' . esc_html__( 'Next', 'qxygen' ) . '</div>'.
			                        '<span class="title-direct">%title</span></div>',
			                    'prev_text' => '<span class="meta-nav"><i class="flaticon-left-arrow-2"></i></span> ' .
			                        '<div class="inner">'.
			                        '<div class="navi"> ' . esc_html__( 'Prev', 'qxygen' ) . '</div>'.
			                        '<span class="title-direct">%title</span></div>',
			                ) );
			            ?>
			        </div>
					<?php
					get_template_part( 'template-apartment/recent-apartment' );

				// End the loop.
				endwhile;
			?>

			</main><!-- .site-main -->
		</div><!-- .content-area -->
		
		<?php qxygen_display_sidebar_right( $sidebar_configs ); ?>
		
	</div>
</section>
<?php get_footer(); ?>