<?php
$post_format = get_post_format();
global $post;
?>
<article id="post-<?php the_ID(); ?>" <?php post_class(); ?>>
    <div class="inner post-layout">

        <?php if(has_post_thumbnail()) { ?>
            <div class="top-image">
                <div class="date">
                    <?php the_time( get_option('date_format', 'd M, Y') ); ?>
                </div>
                <?php
                    $thumb = qxygen_post_thumbnail();
                    echo trim($thumb);
                ?>
            </div>
        <?php } ?>

    	<div class="entry-content-detail <?php echo esc_attr( (has_post_thumbnail())?'':'no-thumbnail' ); ?>">

            <div class="meta">
                <div class="author">
                    <a href="<?php the_permalink(); ?>">
                        <i class="ti-user"></i><?php echo get_the_author(); ?>
                    </a>
                </div>
                <div class="comments"><i class="ti-comment-alt"></i><?php comments_number( esc_html__('0 Comments', 'qxygen'), esc_html__('1 Comment', 'qxygen'), esc_html__('% Comments', 'qxygen') ); ?>
                </div>
                <?php qxygen_post_categories($post); ?>
                <?php if ( empty($thumb) ){ ?>
                    <div class="date"><i class="ti-calendar"></i><?php the_time( get_option('date_format', 'd M, Y') ); ?></div>
                <?php } ?>
            </div>

            <?php if (get_the_title()) { ?>
                <h1 class="entry-title">
                    <?php the_title(); ?>
                </h1>
            <?php } ?>

        	<div class="single-info">
                <div class="entry-description">
                    <?php
                        the_content();
                    ?>
                </div><!-- /entry-content -->
        		<?php
        		wp_link_pages( array(
        			'before'      => '<div class="page-links"><span class="page-links-title">' . esc_html__( 'Pages:', 'qxygen' ) . '</span>',
        			'after'       => '</div>',
        			'link_before' => '<span>',
        			'link_after'  => '</span>',
        			'pagelink'    => '<span class="screen-reader-text">' . esc_html__( 'Page', 'qxygen' ) . ' </span>%',
        			'separator'   => '',
        		) );
        		?>
                <?php  
                    $posttags = get_the_tags();
                ?>
                <?php if( !empty($posttags) || qxygen_get_config('show_blog_social_share', false) ){ ?>
            		<div class="tag-social flex-middle-sm">
                        
            			<?php if( !empty($posttags) ) {
                            qxygen_post_tags();
            			} ?>
                        
                        <?php if( qxygen_get_config('show_blog_social_share', false) ){ ?>
                            <div class="ali-right">
                                <?php get_template_part( 'template-parts/sharebox' ); ?>
                            </div>
                        <?php } ?>
                        
            		</div>
                <?php } ?>
        	</div>
            
            <?php
                //Previous/next post navigation.
                the_post_navigation( array(
                    'next_text' => '<span class="meta-nav"><i class="flaticon-next-1"></i></span> ' .
                        '<div class="inner">'.
                        '<div class="navi">' . esc_html__( 'Next', 'qxygen' ) . '</div>'.
                        '<span class="title-direct">%title</span></div>',
                    'prev_text' => '<span class="meta-nav"><i class="flaticon-left-arrow-2"></i></span> ' .
                        '<div class="inner">'.
                        '<div class="navi"> ' . esc_html__( 'Prev', 'qxygen' ) . '</div>'.
                        '<span class="title-direct">%title</span></div>',
                ) );
            ?>

        </div>
    </div>

</article>