<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
 
/**
 * Quarty Resume Widget.
 *
 * @since 1.0
 */
class Quarty_Resume_Widget extends Widget_Base {

	public function get_name() {
		return 'quarty-resume';
	}

	public function get_title() {
		return esc_html__( 'Resume', 'quarty-plugin' );
	}

	public function get_icon() {
		return 'eicon-parallax';
	}

	public function get_categories() {
		return [ 'quarty-category' ];
	}

	/**
	 * Register widget controls.
	 *
	 * @since 1.0
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'title_tab',
			[
				'label' => esc_html__( 'Title', 'quarty-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'title',
			[
				'label'       => esc_html__( 'Title', 'quarty-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter title', 'quarty-plugin' ),
				'default'     => esc_html__( 'Title', 'quarty-plugin' ),
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'       => esc_html__( 'Title Tag', 'quarty-plugin' ),
				'type'        => Controls_Manager::SELECT,
				'default' => 'h3',
				'options' => [
					'h1'  => __( 'H1', 'quarty-plugin' ),
					'h2' => __( 'H2', 'quarty-plugin' ),
					'h3' => __( 'H3', 'quarty-plugin' ),
					'h4' => __( 'H4', 'quarty-plugin' ),
					'div' => __( 'DIV', 'quarty-plugin' ),
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'items_tab',
			[
				'label' => esc_html__( 'Items', 'quarty-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'name', [
				'label'       => esc_html__( 'Title', 'quarty-plugin' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter title', 'quarty-plugin' ),
				'default'	=> esc_html__( 'Enter title', 'quarty-plugin' ),
			]
		);

		$repeater->add_control(
			'subname', [
				'label'       => esc_html__( 'Subtitle', 'quarty-plugin' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter subtitle', 'quarty-plugin' ),
				'default'	=> esc_html__( 'Enter subtitle', 'quarty-plugin' ),
			]
		);

		$repeater->add_control(
			'date', [
				'label'       => esc_html__( 'Date', 'quarty-plugin' ),
				'type'        => Controls_Manager::TEXT,
				'label_block' => true,
				'placeholder' => esc_html__( 'Enter date', 'quarty-plugin' ),
				'default'	=> esc_html__( 'Enter date', 'quarty-plugin' ),
			]
		);

		$repeater->add_control(
			'desc', [
				'label'       => esc_html__( 'Description', 'quarty-plugin' ),
				'type'        => Controls_Manager::WYSIWYG,
				'placeholder' => esc_html__( 'Enter description', 'quarty-plugin' ),
				'default'	=> esc_html__( 'Enter description', 'quarty-plugin' ),
			]
		);

		$repeater->add_control(
			'button_label', [
				'label'       => esc_html__( 'Button (Label)', 'quarty-plugin' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Button Label', 'quarty-plugin' ),
				'default'	=> esc_html__( 'Button', 'quarty-plugin' ),
			]
		);

		$repeater->add_control(
			'button_type', [
				'label'       => esc_html__( 'Button (Type)', 'quarty-plugin' ),
				'type'        => Controls_Manager::SELECT,
				'default' => 'link',
				'options' => [
					'link'  => __( 'Link', 'quarty-plugin' ),
					'image' => __( 'Image', 'quarty-plugin' ),
					'testimonial' => __( 'Testimonial', 'quarty-plugin' ),
				],
			]
		);

		$repeater->add_control(
			'link', [
				'label'       => esc_html__( 'Button (Link)', 'quarty-plugin' ),
				'type' => Controls_Manager::URL,
				'show_external' => true,
				'condition' => [
					'button_type' => 'link'
				]
			]
		);

		$repeater->add_control(
			'image', [
				'label'       => esc_html__( 'Image', 'quarty-plugin' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'condition' => [
					'button_type' => 'image'
				]
			]
		);

		$repeater->add_control(
			'rev_image', [
				'label' => esc_html__( 'Image', 'quarty-plugin' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'condition' => [
					'button_type' => 'testimonial'
				]
			]
		);

		$repeater->add_control(
			'rev_name', [
				'label'       => esc_html__( 'Name', 'quarty-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter name', 'quarty-plugin' ),
				'default'	=> esc_html__( 'Enter name', 'quarty-plugin' ),
				'condition' => [
					'button_type' => 'testimonial'
				]
			]
		);

		$repeater->add_control(
			'rev_subname', [
				'label'       => esc_html__( 'Subname', 'quarty-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter subname', 'quarty-plugin' ),
				'default'	=> esc_html__( 'Enter subname', 'quarty-plugin' ),
				'condition' => [
					'button_type' => 'testimonial'
				]
			]
		);

		$repeater->add_control(
			'rev_desc', [
				'label'       => esc_html__( 'Description', 'quarty-plugin' ),
				'type'        => Controls_Manager::WYSIWYG,
				'placeholder' => esc_html__( 'Enter description', 'quarty-plugin' ),
				'default'	=> esc_html__( 'Enter description', 'quarty-plugin' ),
				'condition' => [
					'button_type' => 'testimonial'
				]
			]
		);

		$repeater->add_control(
			'rev_rating', [
				'label'       => esc_html__( 'Rating', 'quarty-plugin' ),
				'type'        => Controls_Manager::NUMBER,
				'placeholder' => esc_html__( 'Enter rating', 'quarty-plugin' ),
				'default'	=> 5,
				'min' => 0,
				'max' => 5,
				'step' => 1,
				'condition' => [
					'button_type' => 'testimonial'
				]
			]
		);

		$this->add_control(
			'items',
			[
				'label' => esc_html__( 'Items', 'quarty-plugin' ),
				'type' => Controls_Manager::REPEATER,
				'prevent_empty' => false,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ name }}}',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'title_styling',
			[
				'label'     => esc_html__( 'Title', 'quarty-plugin' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-section .qrt-title-h' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typography',
				'selector' => '{{WRAPPER}} .qrt-section .qrt-title-h',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'items_styling',
			[
				'label'     => esc_html__( 'Items', 'quarty-plugin' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'item_date_color',
			[
				'label'     => esc_html__( 'Date Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-timeline .qrt-timeline-content .qrt-card-header .qrt-date' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'item_date_bgcolor',
			[
				'label'     => esc_html__( 'Date Background', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-timeline .qrt-timeline-content .qrt-card-header .qrt-date' => 'background-color: {{VALUE}};',
				],
			]
		);		

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'item_date_typography',
				'label'     => esc_html__( 'Date Typography', 'quarty-plugin' ),
				'selector' => '{{WRAPPER}} .qrt-timeline .qrt-timeline-content .qrt-card-header .qrt-date',
			]
		);

		$this->add_control(
			'item_name_color',
			[
				'label'     => esc_html__( 'Title Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-timeline .qrt-timeline-content .qrt-card-header h4' => 'color: {{VALUE}};',
				],
			]
		);		

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'item_name_typography',
				'label'     => esc_html__( 'Title Typography', 'quarty-plugin' ),
				'selector' => '{{WRAPPER}} .qrt-timeline .qrt-timeline-content .qrt-card-header h4',
			]
		);

		$this->add_control(
			'item_subname_color',
			[
				'label'     => esc_html__( 'Subtitle Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-timeline .qrt-timeline-content .qrt-card-header .qrt-el-suptitle' => 'color: {{VALUE}};',
				],
			]
		);		

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'item_subname_typography',
				'label'     => esc_html__( 'Subtitle Typography', 'quarty-plugin' ),
				'selector' => '{{WRAPPER}} .qrt-timeline .qrt-timeline-content .qrt-card-header .qrt-el-suptitle',
			]
		);

		$this->add_control(
			'item_desc_color',
			[
				'label'     => esc_html__( 'Description Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-timeline .qrt-timeline-content .qrt-el-description' => 'color: {{VALUE}};',
				],
			]
		);		

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'item_desc_typography',
				'label'     => esc_html__( 'Description Typography', 'quarty-plugin' ),
				'selector' => '{{WRAPPER}} .qrt-timeline .qrt-timeline-content .qrt-el-description',
			]
		);

		$this->add_control(
			'item_button_color',
			[
				'label'     => esc_html__( 'Button Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-timeline .qrt-timeline-content .qrt-link' => 'color: {{VALUE}};',
				],
			]
		);		

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'item_button_typography',
				'label'     => esc_html__( 'Button Typography', 'quarty-plugin' ),
				'selector' => '{{WRAPPER}} .qrt-timeline .qrt-timeline-content .qrt-link',
			]
		);

		$this->add_control(
			'rev_name_color',
			[
				'label'     => esc_html__( 'Testimonial Name Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-testimonial .qrt-testimonial-header h4' => 'color: {{VALUE}};',
				],
			]
		);		

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'rev_name_typography',
				'label'     => esc_html__( 'Testimonial Name Typography', 'quarty-plugin' ),
				'selector' => '{{WRAPPER}} .qrt-testimonial .qrt-testimonial-header h4',
			]
		);

		$this->add_control(
			'rev_subname_color',
			[
				'label'     => esc_html__( 'Testimonial Subname Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-testimonial .qrt-testimonial-header .qrt-el-suptitle' => 'color: {{VALUE}};',
				],
			]
		);		

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'rev_subname_typography',
				'label'     => esc_html__( 'Testimonial Subname Typography', 'quarty-plugin' ),
				'selector' => '{{WRAPPER}} .qrt-testimonial .qrt-testimonial-header .qrt-el-suptitle',
			]
		);

		$this->add_control(
			'rev_desc_color',
			[
				'label'     => esc_html__( 'Testimonial Description Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-testimonial .qrt-testimonial-text' => 'color: {{VALUE}};',
				],
			]
		);		

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'rev_desc_typography',
				'label'     => esc_html__( 'Testimonial Description Typography', 'quarty-plugin' ),
				'selector' => '{{WRAPPER}} .qrt-testimonial .qrt-testimonial-text',
			]
		);
		
		$this->add_control(
			'rev_rating_color',
			[
				'label'     => esc_html__( 'Testimonial Rating Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-testimonial .qrt-stars li i' => 'color: {{VALUE}};',
				],
			]
		);
		
		$this->end_controls_section();
	}


	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		$this->add_inline_editing_attributes( 'title', 'basic' );

		$theme_lightbox = get_field( 'portfolio_lightbox_disable', 'option' );

		?>

		<div class="qrt-section qrt-section-sf">
			<?php if ( $settings['title'] ) : ?>
			<<?php echo esc_attr( $settings['title_tag'] ); ?> class="qrt-mb-40 qrt-title-h">
				<span <?php echo $this->get_render_attribute_string( 'title' ); ?>>
	          		<?php echo wp_kses_post( $settings['title'] ); ?>
	         	</span>
			</<?php echo esc_attr( $settings['title_tag'] ); ?>>
			<?php endif; ?>

	        <div class="qrt-timeline qrt-mb-40">
	          <?php if ( $settings['items'] ) : ?>
	          <?php foreach ( $settings['items'] as $index => $item ) : $i = rand();
			  $item_name = $this->get_repeater_setting_key( 'name', 'items', $index );
			  $this->add_inline_editing_attributes( $item_name, 'none' );

			  $item_subname = $this->get_repeater_setting_key( 'subname', 'items', $index );
			  $this->add_inline_editing_attributes( $item_subname, 'none' );

			  $item_date = $this->get_repeater_setting_key( 'date', 'items', $index );
			  $this->add_inline_editing_attributes( $item_date, 'none' );

			  $item_desc = $this->get_repeater_setting_key( 'desc', 'items', $index );
			  $this->add_inline_editing_attributes( $item_desc, 'advanced' );

			  $item_button = $this->get_repeater_setting_key( 'button_label', 'items', $index );
			  $this->add_inline_editing_attributes( $item_button, 'none' );
			  ?>
	          <div class="qrt-timeline-item">
	            <div class="qrt-timeline-mark"></div>
	            <div class="qrt-a qrt-timeline-content">
	              <div class="qrt-card-header">
	              	<?php if ( $item['date'] ) : ?>
	                <div class="qrt-date qrt-mb-20">
	                	<span <?php echo $this->get_render_attribute_string( $item_date ); ?>>
		        			<?php echo esc_html( $item['date'] ); ?>
		        		</span>
	                </div>
	                <?php endif; ?>
	                <?php if ( $item['name'] ) : ?>
	                <h4 class="qrt-mb-5">
	                	<span <?php echo $this->get_render_attribute_string( $item_name ); ?>>
		        			<?php echo esc_html( $item['name'] ); ?>
		        		</span>
	                </h4>
	                <?php endif; ?>
	                <?php if ( $item['subname'] ) : ?>
	                <div class="qrt-el-suptitle">
	                	<span <?php echo $this->get_render_attribute_string( $item_subname ); ?>>
		        			<?php echo esc_html( $item['subname'] ); ?>
		        		</span>
	                </div>
	                <?php endif; ?>
	              </div>
	              <?php if ( $item['desc'] ) : ?>
	              <div class="qrt-el-description qrt-mb-20">
	              	<div <?php echo $this->get_render_attribute_string( $item_desc ); ?>>
	        		 <?php echo wp_kses_post( $item['desc'] ); ?>
	        		</div>
	              </div>
	              <?php endif; ?>
	              <?php if ( $item['button_label'] ) : ?>
	              <?php if ( $item['button_type'] == 'image' ) : ?>
	              <a <?php if ( ! $theme_lightbox ) : ?> data-magnific-image<?php endif; ?> data-elementor-lightbox-slideshow="reviews" data-no-swup href="<?php echo esc_url( $item['image']['url'] ); ?>" class="qrt-link qrt-w-chevron">
	              <?php endif; ?>
	              <?php if ( $item['button_type'] == 'link' ) : ?>
	              <a<?php if ( $item['link'] ) : if ( $item['link']['is_external'] ) : ?> target="_blank"<?php endif; ?><?php if ( $item['link']['nofollow'] ) : ?> rel="nofollow"<?php endif; ?> href="<?php echo esc_url( $item['link']['url'] ); ?>"<?php endif; ?> class="qrt-link qrt-w-chevron">
	              <?php endif; ?>
	              <?php if ( $item['button_type'] == 'testimonial' ) : ?>
	              <a data-magnific-inline data-no-swup href="#art-recomendation-popup-<?php echo esc_attr( $i ); ?>" class="qrt-link qrt-w-chevron">
	              <?php endif; ?>
	              	<span <?php echo $this->get_render_attribute_string( $item_button ); ?>>
	        			<?php echo esc_html( $item['button_label'] ); ?>
	        		</span>
	        	  </a>
              	  <?php endif; ?>
	            </div>

	            <?php if ( $item['button_type'] == 'testimonial' ) : ?>
	            <!-- popup -->
	            <div class="qrt-rec-popup mfp-hide mfp-with-anim" id="art-recomendation-popup-<?php echo esc_attr( $i ); ?>">
	              <!-- testimonial -->
	              <div class="qrt-testimonial">
                      <div class="qrt-testimonial-header">
                      	<?php if ( $item['rev_image'] ) : $rev_image = wp_get_attachment_image_url( $item['rev_image']['id'], 'quarty_140x140' ); ?>
                        <img src="<?php echo esc_url( $rev_image ); ?>" alt="<?php echo esc_attr( $item['rev_name'] ); ?>">
                        <?php endif; ?>
                        <div class="qrt-testimonial-name">
                          <?php if ( $item['rev_name'] ) : ?>
                          <h4 class="qrt-mb-5"><?php echo esc_html( $item['rev_name'] ); ?></h4>
                          <?php endif; ?>
                          <?php if ( $item['rev_subname'] ) : ?>
                          <div class="qrt-el-suptitle"><?php echo esc_html( $item['rev_subname'] ); ?></div>
                          <?php endif; ?>
                        </div>
                      </div>
                      <?php if ( $item['rev_desc'] ) : ?>
                      <div class="qrt-testimonial-text">
                        <?php echo wp_kses_post( $item['rev_desc'] ); ?>
                      </div>
                      <?php endif; ?>
                      <?php if ( $item['rev_rating'] ) : ?>
                      <ul class="qrt-stars">
                        <?php for ( $i = 1; $i <= 5; $i++ ) : ?>
		                  <?php if ( $item['rev_rating'] >= $i ) : ?>
		                  <li><i class="fas fa-star"></i></li>
		                  <?php else : ?>
		                  <li class="qrt-empty-item"><i class="fas fa-star"></i></li>
		              	  <?php endif; ?>
		                  <?php endfor; ?>
                      </ul>
                      <?php endif; ?>
                  </div>
	              <!-- testimonial end -->
	            </div>
	            <!-- popup end -->
	            <?php endif; ?>
	          </div>
	          <?php endforeach; ?>
          	  <?php endif; ?>

	        </div>
	    </div>

		<?php
	}

	/**
	 * Render widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function content_template() {
		?>
		<#
		view.addInlineEditingAttributes( 'title', 'basic' );
		#>

		<div class="qrt-section qrt-section-sf">
			<# if ( settings.title ) { #>
			<{{{ settings.title_tag }}} class="qrt-mb-40 qrt-title-h">
				<span {{{ view.getRenderAttributeString( 'title' ) }}}>
	          		{{{ settings.title }}}
	         	</span>
			</{{{ settings.title_tag }}}>
			<# } #>

	        <div class="qrt-timeline qrt-mb-40">
	          <# if ( settings.items ) { var i = 0; #>
			  <# _.each( settings.items, function( item, index ) { 
			  	i++;
				var item_name = view.getRepeaterSettingKey( 'name', 'items', index );
				view.addInlineEditingAttributes( item_name, 'none' );

				var item_subname = view.getRepeaterSettingKey( 'subname', 'items', index );
				view.addInlineEditingAttributes( item_subname, 'none' );

				var item_date = view.getRepeaterSettingKey( 'date', 'items', index );
				view.addInlineEditingAttributes( item_date, 'none' );

				var item_desc = view.getRepeaterSettingKey( 'desc', 'items', index );
				view.addInlineEditingAttributes( item_desc, 'advanced' );

				var item_button = view.getRepeaterSettingKey( 'button_label', 'items', index );
				view.addInlineEditingAttributes( item_button, 'none' );

			  #>
	          <div class="qrt-timeline-item">
	            <div class="qrt-timeline-mark"></div>
	            <div class="qrt-a qrt-timeline-content">
	              <div class="qrt-card-header">
	              	<# if ( item.date ) { #>
	                <div class="qrt-date qrt-mb-20">
	                	<span {{{ view.getRenderAttributeString( item_date ) }}}>
							{{{ item.date }}}
						</span>
	                </div>
	                <# } #>
	                <# if ( item.name ) { #>
	                <h4 class="qrt-mb-5">
	                	<span {{{ view.getRenderAttributeString( item_name ) }}}>
							{{{ item.name }}}
						</span>
	                </h4>
	                <# } #>
	                <# if ( item.subname ) { #>
	                <div class="qrt-el-suptitle">
	                	<span {{{ view.getRenderAttributeString( item_subname ) }}}>
							{{{ item.subname }}}
						</span>
	                </div>
	                <# } #>
	              </div>
	              <# if ( item.desc ) { #>
	              <div class="qrt-el-description qrt-mb-20">
	              	<div {{{ view.getRenderAttributeString( item_desc ) }}}>
						{{{ item.desc }}}
					</div>
	              </div>
	              <# } #>
	              <# if ( item.button_label ) { #>
              	  <# if ( item.button_type == 'image' ) { #>
	              <a data-magnific-image data-elementor-lightbox-slideshow="reviews" data-no-swup href="{{{ item.image.url }}}" class="qrt-link qrt-w-chevron">
	              <# } #>
	              <# if ( item.button_type == 'link' ) { #>
	              <a<# if ( item.link ) { if ( item.link.is_external ) { #> target="_blank"<# } #><# if ( item.link.nofollow ) { #> rel="nofollow"<# } #> href="{{{ item.link.url }}}"<# } #> class="qrt-link qrt-w-chevron">
	              <# } #>
	              <# if ( item.button_type == 'testimonial' ) { #>
	              <a data-magnific-inline data-no-swup href="#art-recomendation-popup-{{{ i }}}" class="qrt-link qrt-w-chevron">
	              <# } #>
	              	<span {{{ view.getRenderAttributeString( item_button ) }}}>
						{{{ item.button_label }}}
					</span>
	        	  </a>
              	  <# } #>
	            </div>

	            <# if ( item.button_type == 'testimonial' ) { #>
	            <!-- popup -->
	            <div class="qrt-rec-popup mfp-hide mfp-with-anim" id="art-recomendation-popup-{{{ i }}}">
	              <!-- testimonial -->
	              <div class="qrt-testimonial">
                      <div class="qrt-testimonial-header">
                      	<# if ( item.rev_image ) { #>
                        <img src="{{{ item.rev_image.url }}}" alt="{{{ item.rev_name }}}">
                        <# } #>
                        <div class="qrt-testimonial-name">
                          <# if ( item.rev_name ) { #>
                          <h4 class="qrt-mb-5">{{{ item.rev_name }}}</h4>
                          <# } #>
                          <# if ( item.rev_subname ) { #>
                          <div class="qrt-el-suptitle">{{{ item.rev_subname }}}</div>
                          <# } #>
                        </div>
                      </div>
                      <# if ( item.rev_desc ) { #>
                      <div class="qrt-testimonial-text">
                        {{{ item.rev_desc }}}
                      </div>
                      <# } #>
                      <# if ( item.rev_rating ) { #>
                      <ul class="qrt-stars">
                          <# for ( var i = 0; i < 5; i++ ) { #>
		                  <# if ( item.rev_rating >= i ) { #>
		                  <li><i class="fas fa-star"></i></li>
		                  <# } else { #>
		                  <li class="qrt-empty-item"><i class="fas fa-star"></i></li>
		              	  <# } #>
		                  <# } #>
                      </ul>
                      <# } #>
                  </div>
	              <!-- testimonial end -->
	            </div>
	            <!-- popup end -->
	            <# } #>
	          </div>
	          <# }); #>
          	  <# } #>

	        </div>
	    </div>

		<?php 
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Quarty_Resume_Widget() );