<?php

/**
 * Register Custom Post Type: Portfolio
 */

function quarty_register_portfolio() {
	register_post_type( 'portfolio', array(
			'label' => esc_html__( 'Portfolio', 'quarty-plugin' ),
	        'description' => esc_html__( 'Portfolio', 'quarty-plugin' ),
	        'supports' => array( 'title','editor','revisions','thumbnail','page-attributes' ),
	        'taxonomies' => array( 'portfolio_categories' ),
	        'hierarchical' => false,
	        'show_in_rest' => true,
	        'public' => true,
	        'show_ui' => true,
	        'show_in_menu' => true,
	        'show_in_nav_menus' => true,
	        'show_in_admin_bar' => true,
	        'menu_position' => 20,
	        'menu_icon' => 'dashicons-images-alt2',
	        'can_export' => true,
	        'has_archive' => false,
	        'exclude_from_search' => true,
	        'publicly_queryable' => true,
	        'capability_type' => 'post',
	        'rewrite' => array( 'slug' => 'portfolio/item', 'with_front' => true  ),
			'labels' => array(
				'name' => esc_html__( 'Portfolio', 'quarty-plugin' ),
		        'singular_name' => esc_html__( 'Portfolio', 'quarty-plugin' ),
		        'menu_name' => esc_html__( 'Portfolio', 'quarty-plugin' ),
		        'parent_item_colon' => esc_html__( 'Parent Portfolio:', 'quarty-plugin' ),
		        'all_items' => esc_html__( 'All Portfolio', 'quarty-plugin' ),
		        'view_item' => esc_html__( 'View Portfolio', 'quarty-plugin' ),
		        'add_new_item' => esc_html__( 'Add New Portfolio', 'quarty-plugin' ),
		        'add_new' => esc_html__( 'New Portfolio', 'quarty-plugin' ),
		        'edit_item' => esc_html__( 'Edit Portfolio', 'quarty-plugin' ),
		        'update_item' => esc_html__( 'Update Portfolio', 'quarty-plugin' ),
		        'search_items' => esc_html__( 'Search Portfolio', 'quarty-plugin' ),
		        'not_found' => esc_html__( 'No portfolio found', 'quarty-plugin' ),
		        'not_found_in_trash' => esc_html__( 'No portfolio found in Trash', 'quarty-plugin' ),
			),
		)
	);
}
add_action( 'init', 'quarty_register_portfolio' );

function quarty_register_portfolio_categories() {
	register_taxonomy( 'portfolio_categories', array ( 0 => 'portfolio' ),
		array(
			'label' => esc_html__( 'Portfolio Categories', 'quarty-plugin' ),
			'hierarchical' => true,
			'show_ui' => true,
			'show_in_rest' => true,
			'show_admin_column' => true,
			'query_var' => true,
			'has_archive' => true,
			'rewrite' => array( 'slug' => 'portfolio-categories' ),
			'labels' => array(
				'name'              => esc_html__( 'Portfolio Categories', 'quarty-plugin' ),
		        'singular_name'     => esc_html__( 'Portfolio Categories', 'quarty-plugin' ),
		        'search_items'      => esc_html__( 'Search Portfolio Category', 'quarty-plugin' ),
		        'all_items'         => esc_html__( 'All Portfolio Category', 'quarty-plugin' ),
		        'parent_item'       => esc_html__( 'Parent Portfolio Category', 'quarty-plugin' ),
		        'parent_item_colon' => esc_html__( 'Parent Portfolio Category:', 'quarty-plugin' ),
		        'edit_item'         => esc_html__( 'Edit Portfolio Category', 'quarty-plugin' ),
		        'update_item'       => esc_html__( 'Update Portfolio Category', 'quarty-plugin' ),
		        'add_new_item'      => esc_html__( 'Add New Portfolio Category', 'quarty-plugin' ),
		        'new_item_name'     => esc_html__( 'New Portfolio Category Name', 'quarty-plugin' ),
		        'menu_name'         => esc_html__( 'Portfolio Category', 'quarty-plugin' ),
			)
		)
	);
}
add_action( 'init', 'quarty_register_portfolio_categories' );