<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
 
/**
 * Quarty Hero Banner Widget.
 *
 * @since 1.0
 */
class Quarty_Hero_Image_Widget extends Widget_Base {

	public function get_name() {
		return 'quarty-hero-image';
	}

	public function get_title() {
		return esc_html__( 'Hero Image', 'quarty-plugin' );
	}

	public function get_icon() {
		return 'eicon-parallax';
	}

	public function get_categories() {
		return [ 'quarty-category' ];
	}

	/**
	 * Register widget controls.
	 *
	 * @since 1.0
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'title_tab',
			[
				'label' => esc_html__( 'Title', 'quarty-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'title',
			[
				'label'       => esc_html__( 'Title', 'quarty-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter your title', 'quarty-plugin' ),
				'default'     => esc_html__( 'Title', 'quarty-plugin' ),
			]
		);

		$this->add_control(
			'title_tag',
			[
				'label'       => esc_html__( 'Title Tag', 'quarty-plugin' ),
				'type'        => Controls_Manager::SELECT,
				'default' => 'h1',
				'options' => [
					'h1'  => __( 'H1', 'quarty-plugin' ),
					'h2' => __( 'H2', 'quarty-plugin' ),
					'h3' => __( 'H3', 'quarty-plugin' ),
					'div' => __( 'DIV', 'quarty-plugin' ),
				],
			]
		);
		
		$this->end_controls_section();

		$this->start_controls_section(
			'subtitle_tab',
			[
				'label' => esc_html__( 'Subtitle', 'quarty-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'subtitle',
			[
				'label'       => esc_html__( 'Subtitle', 'quarty-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter your subtitle', 'quarty-plugin' ),
				'default'     => esc_html__( 'Subtitle', 'quarty-plugin' ),
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'buttons_tab',
			[
				'label' => esc_html__( 'Buttons', 'quarty-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'button1_show',
			[
				'label' => esc_html__( 'Show Button 1', 'quarty-plugin' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'quarty-plugin' ),
				'label_off' => __( 'Hide', 'quarty-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'button1',
			[
				'label'       => esc_html__( 'Button 1 (Label)', 'quarty-plugin' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Button', 'quarty-plugin' ),
				'default'	=> esc_html__( 'Button', 'quarty-plugin' ),
				'condition' => [
		            'button1_show' => 'yes'
		        ],
			]
		);

		$this->add_control(
			'button1_link',
			[
				'label'       => esc_html__( 'Button 1 (URL)', 'quarty-plugin' ),
				'type' => Controls_Manager::URL,
				'show_external' => true,
				'condition' => [
		            'button1_show' => 'yes'
		        ],
			]
		);

		$this->add_control(
			'button2_show',
			[
				'label' => esc_html__( 'Show Button 2', 'quarty-plugin' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'quarty-plugin' ),
				'label_off' => __( 'Hide', 'quarty-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$this->add_control(
			'button2',
			[
				'label'       => esc_html__( 'Button 2 (Label)', 'quarty-plugin' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Button', 'quarty-plugin' ),
				'default'	=> esc_html__( 'Button', 'quarty-plugin' ),
				'condition' => [
		            'button2_show' => 'yes'
		        ],
			]
		);

		$this->add_control(
			'button2_link',
			[
				'label'       => esc_html__( 'Button 2 (URL)', 'quarty-plugin' ),
				'type' => Controls_Manager::URL,
				'show_external' => true,
				'condition' => [
		            'button2_show' => 'yes'
		        ],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'image_tab',
			[
				'label' => esc_html__( 'Background', 'quarty-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$this->add_control(
			'bg_type',
			[
				'label'       => esc_html__( 'Background Type', 'quarty-plugin' ),
				'type'        => Controls_Manager::SELECT,
				'default' => 'image',
				'options' => [
					'image'  => __( 'Image', 'quarty-plugin' ),
					'video' => __( 'Video', 'quarty-plugin' ),
				],
			]
		);

		$this->add_control(
			'bg_image',
			[
				'label'       => esc_html__( 'Background Image', 'quarty-plugin' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'condition' => [
		            'bg_type' => 'image'
		        ],
			]
		);

		$this->add_control(
			'video_poster',
			[
				'label'       => esc_html__( 'Video Poster', 'quarty-plugin' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'condition' => [
		            'bg_type' => 'video'
		        ],
			]
		);

		$this->add_control(
			'video',
			[
				'label'       => esc_html__( 'Video File', 'quarty-plugin' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'condition' => [
		            'bg_type' => 'video'
		        ],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'title_styling',
			[
				'label'     => esc_html__( 'Title', 'quarty-plugin' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-banner-title .title--h1' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typography',
				'selector' => '{{WRAPPER}} .qrt-banner-title .title--h1',
			]
		);

		$this->add_control(
			'divider_color',
			[
				'label'     => esc_html__( 'Divider Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-divider-2' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'subtitle_styling',
			[
				'label'     => esc_html__( 'Subtitle', 'quarty-plugin' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'subtitle_color',
			[
				'label'     => esc_html__( 'Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-banner .qrt-overlay .qrt-banner-title .qrt-text' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'subtitle_typography',
				'selector' => '{{WRAPPER}} .qrt-banner .qrt-overlay .qrt-banner-title .qrt-text',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'button1_styling',
			[
				'label'     => esc_html__( 'Button 1', 'quarty-plugin' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'button1_color',
			[
				'label'     => esc_html__( 'Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-banner .qrt-btn.qrt-btn-color' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button1_bg_color',
			[
				'label'     => esc_html__( 'Background Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-banner .qrt-btn.qrt-btn-color' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'button1_typography',
				'selector' => '{{WRAPPER}} .qrt-banner .qrt-btn.qrt-btn-color',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'button2_styling',
			[
				'label'     => esc_html__( 'Button 2', 'quarty-plugin' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'button2_color',
			[
				'label'     => esc_html__( 'Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-banner .qrt-btn.qrt-btn-border' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button2_bg_color',
			[
				'label'     => esc_html__( 'Border Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-banner .qrt-btn.qrt-btn-border' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'button2_typography',
				'selector' => '{{WRAPPER}} .qrt-banner .qrt-btn.qrt-btn-border',
			]
		);

		$this->end_controls_section();
	}


	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		$this->add_inline_editing_attributes( 'title', 'basic' );
		$this->add_inline_editing_attributes( 'subtitle', 'basic' );
		$this->add_inline_editing_attributes( 'button1', 'none' );
		$this->add_inline_editing_attributes( 'button2', 'none' );

		?>
		<div class="qrt-body">
		<div class="qrt-banner<?php if ( $settings['bg_type'] == 'image' ) : ?> qrt-animated-zoom<?php endif; ?>">
        	<?php if ( $settings['bg_type'] == 'image' ) : ?>
        	<div class="qrt-image-frame">
        		<?php if ( $settings['bg_image'] ) : $image = wp_get_attachment_image_url( $settings['bg_image']['id'], 'quarty_1920xAuto' ); ?>
            	<img src="<?php echo esc_url( $image ); ?>" alt="">
            	<?php endif; ?>
          	</div>
          	<?php else : ?>
          	<video autoplay loop class="qrt-video-background"<?php if ( $settings['video_poster'] ) : $video_poster = wp_get_attachment_image_url( $settings['video_poster']['id'], 'quarty_1920xAuto' ); ?> poster="<?php echo esc_url( $video_poster ); ?>"<?php endif; ?> muted>
            	<source src="<?php echo esc_url( $settings['video'] ); ?>" type="video/mp4">
          	</video>
          	<?php endif; ?>
          	
          	<div class="qrt-overlay">
            	<div class="qrt-banner-title">
            		<?php if ( $settings['title'] ) : ?>
              		<<?php echo esc_attr( $settings['title_tag'] ); ?> class="title--h1 qrt-white qrt-mb-30">
              			<span <?php echo $this->get_render_attribute_string( 'title' ); ?>>
			          		<?php echo wp_kses_post( $settings['title'] ); ?>
			          	</span>
              		</<?php echo esc_attr( $settings['title_tag'] ); ?>>
              		<div class="qrt-divider-2"></div>
              		<?php endif; ?>
              		<?php if ( $settings['subtitle'] ) : ?>
              		<div class="qrt-text qrt-white qrt-mb-20">
              			<span <?php echo $this->get_render_attribute_string( 'subtitle' ); ?>>
			          		<?php echo wp_kses_post( $settings['subtitle'] ); ?>
			          	</span>
              		</div>
              		<?php endif; ?>
              		<?php if ( $settings['button1_show'] == 'yes' ) : ?>
              		<a<?php if ( $settings['button1_link'] ) : if ( $settings['button1_link']['is_external'] ) : ?> target="_blank"<?php endif; ?><?php if ( $settings['button1_link']['nofollow'] ) : ?> rel="nofollow"<?php endif; ?> href="<?php echo esc_url( $settings['button1_link']['url'] ); ?>"<?php endif; ?> class="qrt-btn qrt-btn-md qrt-btn-color qrt-cursor-scale qrt-anima-link qrt-mb-20">
              			<span <?php echo $this->get_render_attribute_string( 'button1' ); ?>>
			          		<?php echo wp_kses_post( $settings['button1'] ); ?>
			          	</span>
              			<i class="fas fa-arrow-right"></i>
              		</a>
              		<?php endif; ?>
              		<?php if ( $settings['button2_show'] == 'yes' ) : ?>
              		<a<?php if ( $settings['button2_link'] ) : if ( $settings['button2_link']['is_external'] ) : ?> target="_blank"<?php endif; ?><?php if ( $settings['button2_link']['nofollow'] ) : ?> rel="nofollow"<?php endif; ?> href="<?php echo esc_url( $settings['button2_link']['url'] ); ?>"<?php endif; ?> class="qrt-btn qrt-btn-md qrt-btn-border qrt-cursor-scale qrt-anima-link qrt-mb-20">
              			<span <?php echo $this->get_render_attribute_string( 'button2' ); ?>>
			          		<?php echo wp_kses_post( $settings['button2'] ); ?>
			          	</span>
              			<i class="fas fa-arrow-right"></i>
              		</a>
              		<?php endif; ?>
            	</div>
          	</div>
        </div>
    	</div>

		<?php
	}

	/**
	 * Render widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function content_template() {
		?>

		<#
		view.addInlineEditingAttributes( 'title', 'basic' );
		view.addInlineEditingAttributes( 'subtitle', 'basic' );
		view.addInlineEditingAttributes( 'button1', 'none' );
		view.addInlineEditingAttributes( 'button2', 'none' );
		#>

		<div class="qrt-body">
		<div class="qrt-banner<# if ( settings.bg_type == 'image' ) { #> qrt-animated-zoom<# } #>">
        	<# if ( settings.bg_type == 'image' ) { #>
        	<div class="qrt-image-frame">
        		<# if ( settings.bg_image ) { #>
            	<img src="{{{ settings.bg_image.url }}}" alt="">
            	<# } #>
          	</div>
          	<# } else { #>
          	<video autoplay loop class="qrt-video-background"<# if ( settings.video_poster ) { #> poster="{{{ settings.video_poster.url }}}"<# } #> muted>
            	<source src="{{{ settings.video }}}" type="video/mp4">
          	</video>
          	<# } #>

          	<div class="qrt-overlay">
            	<div class="qrt-banner-title">
            		<# if ( settings.title ) { #>
              		<{{{ settings.title_tag }}} class="title--h1 qrt-white qrt-mb-30">
              			<span {{{ view.getRenderAttributeString( 'title' ) }}}>
			          		{{{ settings.title }}}
			          	</span>
              		</{{{ settings.title_tag }}}>
              		<div class="qrt-divider-2"></div>
              		<# } #>
              		<# if ( settings.subtitle ) { #>
              		<div class="qrt-text qrt-white qrt-mb-20">
              			<span {{{ view.getRenderAttributeString( 'subtitle' ) }}}>
			          		{{{ settings.subtitle }}}
			          	</span>
              		</div>
              		<# } #>
              		<# if ( settings.button1_show == 'yes' ) { #>
              		<a<# if ( settings.button1_link ) { if ( settings.button1_link.is_external ) { #> target="_blank"<# } #><# if ( settings.button1_link.nofollow ) { #> rel="nofollow"<# } #> href="{{{ settings.button1_link.url }}}"<# } #> class="qrt-btn qrt-btn-md qrt-btn-color qrt-cursor-scale qrt-anima-link qrt-mb-20">
              			<span {{{ view.getRenderAttributeString( 'button1' ) }}}>
			          		{{{ settings.button1 }}}
			          	</span>
              			<i class="fas fa-arrow-right"></i>
              		</a>
              		<# } #>
              		<# if ( settings.button2_show == 'yes' ) { #>
              		<a<# if ( settings.button2_link ) { if ( settings.button2_link.is_external ) { #> target="_blank"<# } #><# if ( settings.button2_link.nofollow ) { #> rel="nofollow"<# } #> href="{{{ settings.button2_link.url }}}"<# } #> class="qrt-btn qrt-btn-md qrt-btn-border qrt-cursor-scale qrt-anima-link qrt-mb-20">
              			<span {{{ view.getRenderAttributeString( 'button2' ) }}}>
			          		{{{ settings.button2 }}}
			          	</span>
              			<i class="fas fa-arrow-right"></i>
              		</a>
              		<# } #>
            	</div>
          	</div>
        </div>
    	</div>

		<?php 
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Quarty_Hero_Image_Widget() );