<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
 
/**
 * Quarty Hero Banner Widget.
 *
 * @since 1.0
 */
class Quarty_Hero_Slider_Widget extends Widget_Base {

	public function get_name() {
		return 'quarty-hero-slider';
	}

	public function get_title() {
		return esc_html__( 'Hero Slider', 'quarty-plugin' );
	}

	public function get_icon() {
		return 'eicon-parallax';
	}

	public function get_categories() {
		return [ 'quarty-category' ];
	}

	/**
	 * Register widget controls.
	 *
	 * @since 1.0
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'items_tab',
			[
				'label' => esc_html__( 'Slides', 'quarty-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'type', [
				'label'	=> esc_html__( 'Type', 'quarty-plugin' ),
				'type'	=> Controls_Manager::SELECT,
				'default' => 'image',
				'options' => [
					'image'  => __( 'Image', 'quarty-plugin' ),
					'video' => __( 'Video', 'quarty-plugin' ),
				],
			]
		);

		$repeater->add_control(
			'image', [
				'label' => esc_html__( 'Image', 'quarty-plugin' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'condition' => [
		            'type' => 'image'
		        ],
			]
		);

		$repeater->add_control(
			'video_poster', [
				'label'	=> esc_html__( 'Video Poster', 'quarty-plugin' ),
				'type' => Controls_Manager::MEDIA,
				'default' => [
					'url' => \Elementor\Utils::get_placeholder_image_src(),
				],
				'condition' => [
		            'type' => 'video'
		        ],
			]
		);

		$repeater->add_control(
			'video', [
				'label'	=> esc_html__( 'Video File', 'quarty-plugin' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'condition' => [
		            'type' => 'video'
		        ],
			]
		);

		$repeater->add_control(
			'title', [
				'label'       => esc_html__( 'Title', 'quarty-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter title', 'quarty-plugin' ),
				'default'	=> esc_html__( 'Enter title', 'quarty-plugin' ),
			]
		);

		$repeater->add_control(
			'title_tag', [
				'label'	=> esc_html__( 'Title Tag', 'quarty-plugin' ),
				'type'	=> Controls_Manager::SELECT,
				'default' => 'h1',
				'options' => [
					'h1'  => __( 'H1', 'quarty-plugin' ),
					'h2' => __( 'H2', 'quarty-plugin' ),
					'h3' => __( 'H3', 'quarty-plugin' ),
					'div' => __( 'DIV', 'quarty-plugin' ),
				],
			]
		);

		$repeater->add_control(
			'subtitle', [
				'label'       => esc_html__( 'Subtitle', 'quarty-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter subtitle', 'quarty-plugin' ),
				'default'	=> esc_html__( 'Enter subtitle', 'quarty-plugin' ),
			]
		);

		$repeater->add_control(
			'button1_show', [
				'label' => esc_html__( 'Show Button 1', 'quarty-plugin' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'quarty-plugin' ),
				'label_off' => __( 'Hide', 'quarty-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$repeater->add_control(
			'button1', [
				'label'       => esc_html__( 'Button 1 (Label)', 'quarty-plugin' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Button', 'quarty-plugin' ),
				'default'	=> esc_html__( 'Button', 'quarty-plugin' ),
				'condition' => [
		            'button1_show' => 'yes'
		        ],
			]
		);

		$repeater->add_control(
			'button1_link', [
				'label'       => esc_html__( 'Button 1 (URL)', 'quarty-plugin' ),
				'type' => Controls_Manager::URL,
				'show_external' => true,
				'condition' => [
		            'button1_show' => 'yes'
		        ],
			]
		);

		$repeater->add_control(
			'button2_show', [
				'label' => esc_html__( 'Show Button 2', 'quarty-plugin' ),
				'type' => Controls_Manager::SWITCHER,
				'label_on' => __( 'Show', 'quarty-plugin' ),
				'label_off' => __( 'Hide', 'quarty-plugin' ),
				'return_value' => 'yes',
				'default' => 'yes',
			]
		);

		$repeater->add_control(
			'button2', [
				'label'       => esc_html__( 'Button 2 (Label)', 'quarty-plugin' ),
				'label_block' => true,
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Button', 'quarty-plugin' ),
				'default'	=> esc_html__( 'Button', 'quarty-plugin' ),
				'condition' => [
		            'button2_show' => 'yes'
		        ],
			]
		);

		$repeater->add_control(
			'button2_link', [
				'label'       => esc_html__( 'Button 2 (URL)', 'quarty-plugin' ),
				'type' => Controls_Manager::URL,
				'show_external' => true,
				'condition' => [
		            'button2_show' => 'yes'
		        ],
			]
		);

		$this->add_control(
			'items',
			[
				'label' => esc_html__( 'Items', 'quarty-plugin' ),
				'type' => Controls_Manager::REPEATER,
				'prevent_empty' => false,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ title }}}',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'title_styling',
			[
				'label'     => esc_html__( 'Title', 'quarty-plugin' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'title_color',
			[
				'label'     => esc_html__( 'Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-main-slider .title--h1' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'title_typography',
				'selector' => '{{WRAPPER}} .qrt-main-slider .title--h1',
			]
		);

		$this->add_control(
			'divider_color',
			[
				'label'     => esc_html__( 'Divider Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-main-slider .qrt-divider-2' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'subtitle_styling',
			[
				'label'     => esc_html__( 'Subtitle', 'quarty-plugin' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'subtitle_color',
			[
				'label'     => esc_html__( 'Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-main-slider .qrt-text' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'subtitle_typography',
				'selector' => '{{WRAPPER}} .qrt-main-slider .qrt-text',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'button1_styling',
			[
				'label'     => esc_html__( 'Button 1', 'quarty-plugin' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'button1_color',
			[
				'label'     => esc_html__( 'Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-main-slider .qrt-btn.qrt-btn-color' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button1_bg_color',
			[
				'label'     => esc_html__( 'Background Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-main-slider .qrt-btn.qrt-btn-color' => 'background-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'button1_typography',
				'selector' => '{{WRAPPER}} .qrt-main-slider .qrt-btn.qrt-btn-color',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'button2_styling',
			[
				'label'     => esc_html__( 'Button 2', 'quarty-plugin' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'button2_color',
			[
				'label'     => esc_html__( 'Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-main-slider .qrt-btn.qrt-btn-border' => 'color: {{VALUE}};',
				],
			]
		);

		$this->add_control(
			'button2_bg_color',
			[
				'label'     => esc_html__( 'Border Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-main-slider .qrt-btn.qrt-btn-border' => 'border-color: {{VALUE}};',
				],
			]
		);

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'button2_typography',
				'selector' => '{{WRAPPER}} .qrt-main-slider .qrt-btn.qrt-btn-border',
			]
		);

		$this->end_controls_section();
	}


	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();

		?>

		<?php if ( $settings['items'] ) : ?>
		<div class="qrt-body">
		<div class="swiper-container qrt-main-slider">
        	<div class="qrt-slider-pagination">
        		<div class="swiper-pagination swiper-main-pagination"></div>
        	</div>
        	<div class="qrt-slider-navigation qrt-absolute">
            	<div class="qrt-slider-nav-btn qrt-main-prev qrt-cursor-scale qrt-cursor-color">
            		<i class="fas fa-arrow-left"></i>
            		<span><?php echo esc_html__( 'prev', 'quarty-plugin' ); ?></span>
            	</div>
        		<div class="qrt-slider-nav-btn qrt-main-next qrt-cursor-scale qrt-cursor-color">
        			<span><?php echo esc_html__( 'next', 'quarty-plugin' ); ?></span>
        			<i class="fas fa-arrow-right"></i>
        		</div>
        	</div>
        	<div class="swiper-wrapper">
            <?php foreach ( $settings['items'] as $index => $item ) : 
			    $item_title = $this->get_repeater_setting_key( 'title', 'items', $index );
			    $this->add_inline_editing_attributes( $item_title, 'basic' );

			    $item_subtitle = $this->get_repeater_setting_key( 'subtitle', 'items', $index );
			    $this->add_inline_editing_attributes( $item_subtitle, 'basic' );

			    $item_button1 = $this->get_repeater_setting_key( 'button1', 'items', $index );
			    $this->add_inline_editing_attributes( $item_button1, 'none' );

			    $item_button2 = $this->get_repeater_setting_key( 'button2', 'items', $index );
			    $this->add_inline_editing_attributes( $item_button1, 'none' );
			?>
            <div class="swiper-slide">
              	<div class="qrt-project-cover">
              		
                	<div class="qrt-image-frame">
                  		<?php if ( $item['type'] == 'image' ) : ?>
                  			<?php if ( $item['image'] ) : $image = wp_get_attachment_image_url( $item['image']['id'], 'quarty_1920xAuto' ); ?>
                  			<img src="<?php echo esc_url( $image ); ?>" data-swiper-parallax="400" data-swiper-parallax-scale="1.4" alt="">
                  			<?php endif; ?>
                  		<?php else : ?>
                  			<video autoplay loop class="qrt-video-background"<?php if ( $item['video_poster'] ) : $video_poster = wp_get_attachment_image_url( $item['video_poster']['id'], 'quarty_1920xAuto' ); ?> poster="<?php echo esc_url( $video_poster ); ?>"<?php endif; ?> data-swiper-parallax="400" data-swiper-parallax-scale="1.4" muted>
	                    		<source src="<?php echo esc_url( $item['video'] ); ?>" type="video/mp4">
	                  		</video>
	                  	<?php endif; ?>
                	</div>
                	

                	<div class="qrt-overlay">
                  		<div class="qrt-parallax-fix" data-swiper-parallax-x="-400" data-swiper-parallax-duration="1000">
                    		<div class="qrt-banner-title">
		                    	<?php if ( $item['title'] ) : ?>
		                    	<<?php echo esc_attr( $item['title_tag'] ); ?> class="qrt-white qrt-mb-30 title--h1">
		                    		<span <?php echo $this->get_render_attribute_string( $item_title ); ?>>
										<?php echo wp_kses_post( $item['title'] ); ?>
									</span>
		                    	</<?php echo esc_attr( $item['title_tag'] ); ?>>
		                    	<div class="qrt-divider-2"></div>
		                    	<?php endif; ?>
		                    	<?php if ( $item['subtitle'] ) : ?>
		                    	<div class="qrt-text qrt-white qrt-mb-20">
		                    		<span <?php echo $this->get_render_attribute_string( $item_subtitle ); ?>>
										<?php echo wp_kses_post( $item['subtitle'] ); ?>
									</span>
		                    	</div>
		                    	<?php endif; ?>
		                     	<?php if ( $item['button1'] ) : ?>
		                     	<a<?php if ( $item['button1_link'] ) : if ( $item['button1_link']['is_external'] ) : ?> target="_blank"<?php endif; ?><?php if ( $item['button1_link']['nofollow'] ) : ?> rel="nofollow"<?php endif; ?> href="<?php echo esc_url( $item['button1_link']['url'] ); ?>"<?php endif; ?> class="qrt-btn qrt-btn-md qrt-btn-color qrt-cursor-scale qrt-anima-link qrt-mb-20">
		                     		<span <?php echo $this->get_render_attribute_string( $item_button1 ); ?>>
										<?php echo wp_kses_post( $item['button1'] ); ?>
									</span>
		                     		<i class="fas fa-arrow-right"></i>
		                     	</a>
		                     	<?php endif; ?>
		                    	<?php if ( $item['button2'] ) : ?>
		                    	<a<?php if ( $item['button2_link'] ) : if ( $item['button2_link']['is_external'] ) : ?> target="_blank"<?php endif; ?><?php if ( $item['button2_link']['nofollow'] ) : ?> rel="nofollow"<?php endif; ?> href="<?php echo esc_url( $item['button2_link']['url'] ); ?>"<?php endif; ?> class="qrt-btn qrt-btn-md qrt-btn-border qrt-cursor-scale qrt-anima-link qrt-mb-20">
		                    		<span <?php echo $this->get_render_attribute_string( $item_button2 ); ?>>
										<?php echo wp_kses_post( $item['button2'] ); ?>
									</span>
		                    		<i class="fas fa-arrow-right"></i>
		                    	</a>
		                    	<?php endif; ?>
                			</div>
                		</div>
                	</div>
            	</div>
            </div>
            <?php endforeach; ?>

          	</div>
        </div>
    	</div>
        <?php endif; ?>

		<?php
	}

	/**
	 * Render widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function content_template() {
		?>

		<# if ( settings.items ) { #>
		<div class="qrt-body">
		<div class="swiper-container qrt-main-slider">
        	<div class="qrt-slider-pagination">
        		<div class="swiper-pagination swiper-main-pagination"></div>
        	</div>
        	<div class="qrt-slider-navigation qrt-absolute">
            	<div class="qrt-slider-nav-btn qrt-main-prev qrt-cursor-scale qrt-cursor-color">
            		<i class="fas fa-arrow-left"></i>
            		<span>prev</span>
            	</div>
        		<div class="qrt-slider-nav-btn qrt-main-next qrt-cursor-scale qrt-cursor-color">
        			<span>next</span>
        			<i class="fas fa-arrow-right"></i>
        		</div>
        	</div>
        	<div class="swiper-wrapper">
            <# _.each( settings.items, function( item, index ) {
			    var item_title = view.getRepeaterSettingKey( 'title', 'items', index );
			    view.addInlineEditingAttributes( item_title, 'none' );

			    var item_subtitle = view.getRepeaterSettingKey( 'subtitle', 'items', index );
			    view.addInlineEditingAttributes( item_subtitle, 'none' );

			    var item_button1 = view.getRepeaterSettingKey( 'button1', 'items', index );
			    view.addInlineEditingAttributes( item_button1, 'none' );

			    var item_button2 = view.getRepeaterSettingKey( 'button2', 'items', index );
			    view.addInlineEditingAttributes( item_button2, 'none' );
			#>
            <div class="swiper-slide">
              	<div class="qrt-project-cover">
                	<div class="qrt-image-frame">
                  		<# if ( item.type == 'image' ) { #>
                  			<# if ( item.image ) { #>
                  			<img src="{{{ item.image.url }}}" data-swiper-parallax="400" data-swiper-parallax-scale="1.4" alt="" />
                  			<# } #>
                  		<# } else { #>
                  			<video autoplay loop class="qrt-video-background" poster="{{{ item.video_poster.url }}}" data-swiper-parallax="400" data-swiper-parallax-scale="1.4" muted>
	                    		<source src="{{{ item.video }}}" type="video/mp4">
	                  		</video>
	                  	<# } #>
                	</div>

                	<div class="qrt-overlay">
                  		<div class="qrt-parallax-fix" data-swiper-parallax-x="-400" data-swiper-parallax-duration="1000">
                    		<div class="qrt-banner-title">
		                    	<# if ( item.title ) { #>
		                    	<{{{ item.title_tag }}} class="qrt-white qrt-mb-30 title--h1">
		                    		<span {{{ view.getRenderAttributeString( 'item_title' ) }}}>
						          		{{{ item.title }}}
						          	</span>
		                    	</{{{ item.title_tag }}}>
		                    	<div class="qrt-divider-2"></div>
		                    	<# } #>
		                    	<# if ( item.subtitle ) { #>
		                    	<div class="qrt-text qrt-white qrt-mb-20">
		                    		<span {{{ view.getRenderAttributeString( 'item_subtitle' ) }}}>
						          		{{{ item.subtitle }}}
						          	</span>
		                    	</div>
		                    	<# } #>
		                     	<# if ( item.button1_show == 'yes' ) { #>
		                     	<a<# if ( settings.button1_link ) { if ( settings.button1_link.is_external ) { #> target="_blank"<# } #><# if ( settings.button1_link.nofollow ) { #> rel="nofollow"<# } #> href="{{{ settings.button1_link.url }}}"<# } #> class="qrt-btn qrt-btn-md qrt-btn-color qrt-cursor-scale qrt-anima-link qrt-mb-20">
		                     		<span {{{ view.getRenderAttributeString( 'item_button1' ) }}}>
						          		{{{ item.button1 }}}
						          	</span>
		                     		<i class="fas fa-arrow-right"></i>
		                     	</a>
		                     	<# } #>
		                    	<# if ( item.button2_show == 'yes' ) { #>
		                    	<a<# if ( settings.button2_link ) { if ( settings.button2_link.is_external ) { #> target="_blank"<# } #><# if ( settings.button2_link.nofollow ) { #> rel="nofollow"<# } #> href="{{{ settings.button2_link.url }}}"<# } #> class="qrt-btn qrt-btn-md qrt-btn-border qrt-cursor-scale qrt-anima-link qrt-mb-20">
		                    		<span {{{ view.getRenderAttributeString( 'item_button2' ) }}}>
						          		{{{ item.button2 }}}
						          	</span>
		                    		<i class="fas fa-arrow-right"></i>
		                    	</a>
		                    	<# } #>
                			</div>
                		</div>
                	</div>
            	</div>
            </div>
            <# }); #>

          	</div>
        </div>
    	</div>
        <# } #>

		<?php 
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Quarty_Hero_Slider_Widget() );