<?php
namespace Elementor;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly
 
/**
 * Quarty Numbers Widget.
 *
 * @since 1.0
 */
class Quarty_Numbers_Widget extends Widget_Base {

	public function get_name() {
		return 'quarty-numbers';
	}

	public function get_title() {
		return esc_html__( 'Numbers', 'quarty-plugin' );
	}

	public function get_icon() {
		return 'eicon-parallax';
	}

	public function get_categories() {
		return [ 'quarty-category' ];
	}

	/**
	 * Register widget controls.
	 *
	 * @since 1.0
	 */
	protected function register_controls() {

		$this->start_controls_section(
			'items_tab',
			[
				'label' => esc_html__( 'Items', 'quarty-plugin' ),
				'tab' => Controls_Manager::TAB_CONTENT,
			]
		);

		$repeater = new \Elementor\Repeater();

		$repeater->add_control(
			'value', [
				'label'       => esc_html__( 'Number Value', 'quarty-plugin' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter number value', 'quarty-plugin' ),
				'default'	=> 99,
			]
		);

		$repeater->add_control(
			'after', [
				'label'       => esc_html__( 'After Text', 'quarty-plugin' ),
				'type'        => Controls_Manager::TEXT,
				'placeholder' => esc_html__( 'Enter after text', 'quarty-plugin' ),
			]
		);

		$repeater->add_control(
			'label', [
				'label'       => esc_html__( 'Label', 'quarty-plugin' ),
				'type'        => Controls_Manager::TEXTAREA,
				'placeholder' => esc_html__( 'Enter label', 'quarty-plugin' ),
				'default'	=> esc_html__( 'Label', 'quarty-plugin' ),
			]
		);

		$this->add_control(
			'items',
			[
				'label' => esc_html__( 'Numbers Items', 'quarty-plugin' ),
				'type' => Controls_Manager::REPEATER,
				'prevent_empty' => false,
				'fields' => $repeater->get_controls(),
				'title_field' => '{{{ label }}}',
			]
		);

		$this->end_controls_section();

		$this->start_controls_section(
			'items_styling',
			[
				'label'     => esc_html__( 'Items', 'quarty-plugin' ),
				'tab'       => Controls_Manager::TAB_STYLE,
			]
		);

		$this->add_control(
			'item_value_color',
			[
				'label'     => esc_html__( 'Number Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-counter-frame .qrt-counter-box .qrt-counter, {{WRAPPER}} .qrt-counter-frame .qrt-counter-box .qrt-counter-plus' => 'color: {{VALUE}};',
				],
			]
		);		

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'item_value_typography',
				'label'     => esc_html__( 'Number Typography', 'quarty-plugin' ),
				'selector' => '{{WRAPPER}} .qrt-counter-frame .qrt-counter-box .qrt-counter, {{WRAPPER}} .qrt-counter-frame .qrt-counter-box .qrt-counter-plus',
			]
		);

		$this->add_control(
			'item_label_color',
			[
				'label'     => esc_html__( 'Label Color', 'quarty-plugin' ),
				'type'      => Controls_Manager::COLOR,
				'default'	=> '',
				'selectors' => [
					'{{WRAPPER}} .qrt-counter-frame h5' => 'color: {{VALUE}};',
				],
			]
		);		

		$this->add_group_control(
			Group_Control_Typography::get_type(),
			[
				'name'     => 'item_label_typography',
				'label'     => esc_html__( 'Label Typography', 'quarty-plugin' ),
				'selector' => '{{WRAPPER}} .qrt-counter-frame h5',
			]
		);
		
		$this->end_controls_section();
	}


	/**
	 * Render widget output on the frontend.
	 *
	 * @since 1.0
	 */
	protected function render() {
		$settings = $this->get_settings_for_display();
		?>

		<?php if ( $settings['items'] ) : ?>
		<div class="qrt-section qrt-section-sf">
			<div class="row">
	          <?php foreach ( $settings['items'] as $index => $item ) : 
			  $item_value = $this->get_repeater_setting_key( 'value', 'items', $index );
			  $this->add_inline_editing_attributes( $item_value, 'none' );

			  $item_label = $this->get_repeater_setting_key( 'label', 'items', $index );
			  $this->add_inline_editing_attributes( $item_label, 'basic' );
			  ?>
	          <div class="col-lg-3 col-sm-6">

	            <div class="qrt-counter-frame">
	              <div class="qrt-counter-box">
	                <span class="qrt-counter">
	                	<span <?php echo $this->get_render_attribute_string( $item_value ); ?>>
		        			<?php echo esc_html( $item['value'] ); ?>
		        		</span>
	                </span>
	                <?php if ( $item['after'] ) : ?>
		        	<span class="qrt-counter-plus"><?php echo esc_html( $item['after'] ); ?></span>
		    		<?php endif; ?>
	              </div>
	              <h5>
	              	<span <?php echo $this->get_render_attribute_string( $item_label ); ?>>
	        			<?php echo wp_kses_post( $item['label'] ); ?>
	        		</span>
	              </h5>
	            </div>

	          </div>
	          <?php endforeach; ?>
	        </div>
	    </div>
	    <?php endif; ?>

		<?php
	}

	/**
	 * Render widget output in the editor.
	 *
	 * Written as a Backbone JavaScript template and used to generate the live preview.
	 *
	 * @since 1.0.0
	 * @access protected
	 */
	protected function content_template() {
		?>

		<# if ( settings.items ) { #>
		<div class="qrt-section qrt-section-sf">
			<div class="row">
	          <# _.each( settings.items, function( item, index ) { 

			  var item_value = view.getRepeaterSettingKey( 'value', 'items', index );
			  view.addInlineEditingAttributes( item_value, 'none' );

			  var item_label = view.getRepeaterSettingKey( 'label', 'items', index );
			  view.addInlineEditingAttributes( item_label, 'basic' );

			  #>
	          <div class="col-lg-3 col-sm-6">

	            <div class="qrt-counter-frame">
	              <div class="qrt-counter-box">
	                <span class="qrt-counter">
	                	<span {{{ view.getRenderAttributeString( item_value ) }}}>
		        			{{{ item.value }}}
		        		</span>
	                </span>
	                <# if ( item.after ) { #>
		        	<span class="qrt-counter-plus">{{{ item.after }}}</span>
		    		<# } #>
	              </div>
	              <h5>
	              	<span {{{ view.getRenderAttributeString( item_label ) }}}>
	        			{{{ item.label }}}
	        		</span>
	              </h5>
	            </div>

	          </div>
	          <# }); #>
	        </div>
	    </div>
	    <# } #>

		<?php 
	}
}

Plugin::instance()->widgets_manager->register_widget_type( new Quarty_Numbers_Widget() );