<?php

function quarty_ocdi_import_files() {
    return array(
        array(
            'import_file_name'             => esc_attr__( 'Default', 'quarty' ),
            'categories'                   => array( esc_attr__( 'Main', 'quarty' ) ),
            'local_import_file'            => trailingslashit( get_template_directory() ) . 'demo/01/content.xml',
            'preview_url'                  => esc_url( 'https://quarty.bslthemes.com/' ),
        ),
    );
}
add_filter( 'pt-ocdi/import_files', 'quarty_ocdi_import_files' );

function quarty_ocdi_after_import_setup( $selected_import ) {
    // Assign menus to their locations.
    $main_menu = get_term_by( 'name', 'Main Menu', 'nav_menu' );

    set_theme_mod( 'nav_menu_locations', array(
            'primary' => $main_menu->term_id,
        )
    );

    // Assign front page and posts page (blog page).
    $front_page_id = get_page_by_title( 'Home Slider' );

    update_option( 'show_on_front', 'page' );
    update_option( 'page_on_front', $front_page_id->ID );
    update_option( 'posts_per_page', 6 );

    $ocdi_fields_static = array(
        'options_theme_scrolling' => 1,
        '_options_theme_scrolling' => 'field_5f73a3eb21ad3',
        'options_social_links_1_icon' => 'fab fa-instagram',
        '_options_social_links_1_icon' => 'field_5d879352bc7a2',
        'options_social_links_1_url' => 'https://instagram.com/',
        '_options_social_links_1_url' => 'field_5b68ccd7c1b65',
        'options_social_links_2_icon' => 'fab fa-twitter',
        '_options_social_links_2_icon' => 'field_5d879352bc7a2',
        'options_social_links_2_url' => 'https://twitter.com/',
        '_options_social_links_2_url' => 'field_5b68ccd7c1b65',
        'options_blog_layout' => 1,
        '_options_blog_layout' => 'field_6030235cbbc92',
        '_options_header_btn_url' => 'field_602fc162530e9',
        'options_header_btn_url' => '/contact/',
        '_options_header_btn_label' => 'field_602fc155530e8',
        'options_header_btn_label' => 'Send request',
        '_options_header_btn' => 'field_602fc13b530e7',
        'options_header_btn' => 1,
        'options_portfolio_lightbox_disable' => 0,
        '_options_portfolio_lightbox_disable' => 'field_5f58eee9befad',
        'options_post_page' => 166,
        '_options_post_page' => 'field_5f588f84087e0',
        'options_portfolio_page' => 162,
        '_options_portfolio_page' => 'field_5f58901c087e1',
        'options_theme_transition' => 0,
        '_options_theme_transition' => 'field_5f5c89409b5e6',
        'options_portfolio_layout' => 0,
        '_options_portfolio_layout' => 'field_6043acea9cc82',
        'options_page_layout' => 0,
        '_options_page_layout' => 'field_602308ace2a3b',
        'options_header_logo' => 1405,
        '_options_header_logo' => 'field_602faa369fa61',
        'options_header_sm_logo' => 1406,
        '_options_header_sm_logo' => 'field_602faa4b9fa62',
        'options_preloader_hide_logo' => 0,
        '_options_preloader_hide_logo' => 'field_5f58b3fc5f79f',
        'options_footer_text' => '© 2021 All Rights Reserved.',
        '_options_footer_text' => 'field_5b68cceac1b66',
        'options_social_links_0_icon' => 'fab fa-facebook-f',
        '_options_social_links_0_icon' => 'field_5d879352bc7a2',
        'options_social_links_0_url' => 'https://facebook.com/',
        '_options_social_links_0_url' => 'field_5b68ccd7c1b65',
        'options_social_links' => 3,
        '_options_social_links' => 'field_5b68ccabc1b63',
        'options_blog_subtitle' => '',
        '_options_blog_subtitle' => 'field_5e5e39b87f0e0',
        'options_blog_categories' => 1,
        '_options_blog_categories' => 'field_5b81b6d930cb9',
        'options_blog_excerpt' => 0,
        '_options_blog_excerpt' => 'field_5b81b7ca30cba',
        'options_blog_featured_img' => 0,
        '_options_blog_featured_img' => 'field_5ee8e1ce18975',
        'options_social_share' => 'a:5:{i:0;s:8:"facebook";i:1;s:7:"twitter";i:2;s:8:"linkedin";i:3;s:6:"reddit";i:4;s:9:"pinterest";}',
        '_options_social_share' => 'field_5c610c399cf20',
        'options_p404_title' => 'Whoops!',
        '_options_p404_title' => 'field_5d180fd559b7f',
        'options_p404_content' => 'The page you\'re looking for doesn\'t exist or has been moved.',
        '_options_p404_content' => 'field_5d180feb59b80',
        'options_post_layout' => 0,
        '_options_post_layout' => 'field_602308ace2a3b',
    );
    $ocdi_fields_to_change = array();
    
    if( 'Default' === $selected_import['import_file_name'] ) {
        $ocdi_fields_to_change = array(
            'options_text_color' => '',
            '_options_text_color' => 'field_5b68d617665db',
            'options_theme_color' => '',
            '_options_theme_color' => 'field_5b68d509665d9',
            'options_heading_color' => '',
            '_options_heading_color' => 'field_5b68d5d8665da',
            'options_heading_font_family' => 0,
            '_options_heading_font_family' => 'field_5b68cfc4906fc',
            'options_text_font_family' => 0,
            '_options_text_font_family' => 'field_5b68d188906fd',
            'options_heading_font_size' => '',
            '_options_heading_font_size' => 'field_5eea66185ad1d',
            'options_text_font_size' => '',
            '_options_text_font_size' => 'field_5eea66ad5ad1e',
            'options_menu_font_size' => '',
            '_options_menu_font_size' => 'field_5eea67685ad1f',
            'options_menu_font_color' => '',
            '_options_menu_font_color' => 'field_5eea679c5ad20',
            'options_menu_font_family' => 0,
            '_options_menu_font_family' => 'field_5eea67ef5ad21',
        );
    }

    global $wpdb;
    foreach ( array_merge( $ocdi_fields_static, $ocdi_fields_to_change ) as $field => $value ) {
        if ( $wpdb->get_var( $wpdb->prepare( "SELECT COUNT(*) FROM $wpdb->options WHERE option_name = %s", $field ) ) == 0 ) {
            $wpdb->query( $wpdb->prepare( "INSERT INTO $wpdb->options ( option_name, option_value, autoload ) VALUES (%s, %s, 'no')", $field, $value ) );
        } else {
            $wpdb->query( $wpdb->prepare( "UPDATE $wpdb->options SET option_value = %s WHERE option_name = %s", $value, $field ) );
        }
    }

}
add_action( 'pt-ocdi/after_import', 'quarty_ocdi_after_import_setup' );