<?php
/**
 * The template for displaying all single posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/#single-post
 *
 * @package quarty
 */

get_header();
?>

<?php

$blog_featured_img = get_field( 'blog_featured_img', 'option' );
$theme_lightbox = get_field( 'portfolio_lightbox_disable', 'option' );

?>

	<?php while ( have_posts() ) : the_post(); ?>
		<div class="qrt-left-content">

		<!-- section title -->
		<div class="qrt-section-title">
			<!-- row -->
			<div class="row">
				<!-- col -->
		  		<div class="col-lg-12">
					<h1 class="title--h2"><?php the_title(); ?></h1>
		      		<div class="qrt-el-suptitle qrt-el-date">
		        		<?php the_date(); ?>
		      		</div>
		  		</div>
		  		<!-- col end -->
		  	</div>
		  	<!-- row end -->
		</div>
		<!-- section title end -->

		<?php if ( has_post_thumbnail() && ! $blog_featured_img ) : ?>
		<div class="row qrt-p-0-40">
          <div class="col-lg-12">
            <div class="qrt-featured-image qrt-work-item">
            	<a<?php if ( ! $theme_lightbox ) : ?> data-magnific-image<?php endif; ?> data-no-swup href="<?php the_post_thumbnail_url( 'quarty_1920xAuto' ); ?>" class="qrt-cursor-scale qrt-work-cover-frame">
            		<?php 
            			the_post_thumbnail( 'quarty_1920xAuto', array(
							'alt' => the_title_attribute( array(
								'echo' => false,
							)),
						) ); 
					?>
					<div class="qrt-item-zoom qrt-cursor-color"><i class="fas fa-expand"></i></div>
                </a>
         	</div>
          </div>
        </div>
	    <?php endif; ?>
		
		<!-- row -->
		<div class="row">
		  <!-- col -->
		  <div class="col-lg-12">
		  	<?php get_template_part( 'template-parts/content', 'single' ); ?>
		  </div>
		  <!-- col end -->
		</div>
        <!-- row end -->

        <?php if ( comments_open() || get_comments_number() ) : ?>
		<!-- row -->
		<div class="row">
		  <!-- col -->
		  <div class="col-lg-12">
		    <?php
			// If comments are open or we have at least one comment, load up the comment template.
			comments_template();
		    ?>
		  </div>
		  <!-- col end -->
		</div>
        <!-- row end -->
        <?php endif; ?>
        
		<?php quarty_single_navigantion(); ?>

		</div>
	<?php endwhile; ?>

<?php
get_footer();