<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package quarty
 */

?>

<?php

$image = get_the_post_thumbnail_url( get_the_ID(), 'quarty_950xAuto' );
$blog_categories = get_field( 'blog_categories', 'option' );
$blog_excerpt = get_field( 'blog_excerpt', 'option' );
$excerpt_text = get_the_excerpt();

?>


<div id="post-<?php the_ID(); ?>" <?php post_class( 'qrt-post-frame' ); ?>>
  <a href="<?php echo esc_url( get_permalink() ); ?>" class="qrt-post-thumb<?php if ( ! $image ) : ?> qrt-post-thumb-empty<?php endif; ?> qrt-cursor-scale qrt-anima-link">
    <?php if ( $image ) : ?>
    <img src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr( get_the_title() ); ?>">
    <?php endif; ?>
    <?php if ( get_post_type() == 'post' ) : ?>
    <div class="qrt-post-date">
      <?php 
      if( $blog_categories ) : 
        $categories_list = get_the_category();
        if ( $categories_list ) :
      ?>
      <span>
      	<i class="fa fa-user-o"></i>
      	<?php
    				$total = count( $categories_list );
    				$i = 0;
    				echo '<span class="qrt-el-category">';
    				foreach ( $categories_list as $category ) { $i++;
    					if ( $total != $i ) {
    						echo esc_html( $category->cat_name ) . esc_html__( ', ', 'quarty' );
    					} else {
    						echo esc_html( $category->cat_name );
    					}
    				}
    				echo '</span>';
    		?>
      </span>
      <?php endif; endif; ?>
      <span><i class="fa fa-clock-o"></i> <?php echo esc_html( get_the_date() ); ?></span>
    </div>
    <?php endif; ?>
  </a>
  <div class="qrt-post-descr">
    <div>
      <h4 class="qrt-cursor-color qrt-post-title"><a href="<?php echo esc_url( get_permalink() ); ?>" class="qrt-anima-link"><?php the_title(); ?></a></h4>
      <?php if ( ! $blog_excerpt && $excerpt_text ) : ?>
      <div class="qrt-port-short-text"><?php the_excerpt(); ?></div>
      <?php endif; ?>
    </div>
  </div>
</div>