<?php
/**
 * Template part for displaying posts
 *
 * @link https://developer.wordpress.org/themes/basics/template-hierarchy/
 *
 * @package quarty
 */

?>

<?php

/* post content */
$current_categories = get_the_terms( get_the_ID(), 'portfolio_categories' );
$categories_string = '';
$categories_slugs_string = '';
if ( $current_categories && ! is_wp_error( $current_categories ) ) {
	$arr_keys = array_keys( $current_categories );
	$last_key = end( $arr_keys );
	foreach ( $current_categories as $key => $value ) {
		if ( $key == $last_key ) {
			$categories_string .= $value->name . ' ';
		} else {
			$categories_string .= $value->name . esc_html__(', ', 'quarty' );
		}
		$categories_slugs_string .= 'category-' . $value->slug . ' ';
	}
}

$image = get_the_post_thumbnail_url( get_the_ID(), 'quarty_800x800' );
$title = get_the_title();
$href = get_the_permalink();
$theme_lightbox = get_field( 'portfolio_lightbox_disable', 'option' );
$grid_size = get_field( 'grid_size' );

?>

<div class="qrt-masonry-grid-item qrt-masonry-grid-item-50<?php if ( $grid_size == 1 ) : ?> qrt-masonry-grid-item-h-x-2<?php endif; ?><?php if ( $grid_size == 2 ) : ?> qrt-masonry-grid-item-100<?php endif; ?> <?php echo esc_attr( $categories_slugs_string ); ?>">
  <div class="qrt-work-item">
    <?php if ( $image ) : ?>
    <a <?php if ( ! $theme_lightbox ) : ?> data-magnific-gallery<?php endif; ?> data-no-swup data-elementor-lightbox-slideshow="gallery" data-elementor-lightbox-title="<?php echo esc_attr( $title ); ?>" href="<?php echo esc_url( $image ); ?>" class="qrt-cursor-scale qrt-work-cover-frame">
      <img src="<?php echo esc_url( $image ); ?>" alt="<?php echo esc_attr( $title ); ?>">
      <div class="qrt-item-zoom qrt-cursor-color"><i class="fas fa-expand"></i></div>
      <div class="qrt-work-category"><span><?php echo esc_html( $categories_string ); ?></span></div>
    </a>
    <?php endif; ?>
    <div class="qrt-work-descr">
      <?php if ( $title ) : ?>
      <h4 class="qrt-cursor-color qrt-white">
        <a href="<?php echo esc_url( $href ); ?>" class="qrt-anima-link"><?php echo esc_html( $title ); ?></a>
      </h4>
      <?php endif; ?>
      <a href="<?php echo esc_url( $href ); ?>" class="qrt-cursor-scale qrt-work-more qrt-anima-link"><i class="fas fa-arrow-right"></i></a>
    </div>
  </div>
</div>