<?php
  if ( is_singular( 'post' ) ) {
    $page_layout = get_field( 'post_layout', 'option' );
    $page_title = get_field( 'post_title', 'option' );
    $page_description = get_field( 'post_description', 'option' );
    $page_button = get_field( 'post_button', 'option' );
    $page_button_url = get_field( 'post_button_url', 'option' );
    $page_bg_image = get_field( 'post_bg_image', 'option' );
    $page_bg_animation = get_field( 'post_bg_animation', 'option' );
    $bg_type = get_field( 'post_bg_type', 'option' );
    $bg_image = wp_get_attachment_image_url( $page_bg_image, 'quarty_1920xAuto' );
    $bg_video = get_field( 'post_bg_video', 'option' );
  } else if ( is_singular( 'portfolio' ) ) {
    $page_layout = get_field( 'portfolio_layout', 'option' );
    $page_title = get_field( 'portfolio_title', 'option' );
    $page_description = get_field( 'portfolio_description', 'option' );
    $page_button = get_field( 'portfolio_button', 'option' );
    $page_button_url = get_field( 'portfolio_button_url', 'option' );
    $page_bg_image = get_field( 'portfolio_bg_image', 'option' );
    $page_bg_animation = get_field( 'portfolio_bg_animation', 'option' );
    $bg_type = get_field( 'portfolio_bg_type', 'option' );
    $bg_image = wp_get_attachment_image_url( $page_bg_image, 'quarty_1920xAuto' );
    $bg_video = get_field( 'portfolio_bg_video', 'option' );
  } else {
    $page_layout = get_field( 'page_layout' );
    $page_title = get_field( 'page_title' );
    $page_scroll = get_field( 'page_scrolldown' );
    $page_description = get_field( 'page_description' );
    $page_button = get_field( 'page_button' );
    $page_button_url = get_field( 'page_button_url' );
    $page_bg_image = get_field( 'page_bg_image' );
    $page_bg_animation = get_field( 'page_bg_animation' );
    $bg_type = get_field( 'page_bg_type' );
    $bg_image = wp_get_attachment_image_url( $page_bg_image, 'quarty_1920xAuto' );
    $bg_video = get_field( 'page_bg_video' );
    $bg_map_long = get_field( 'page_bg_map_long' );
    $bg_map_lat = get_field( 'page_bg_map_lat' );
    $bg_map_zoom = get_field( 'page_bg_map_zoom' );
  }

  if ( is_archive() || is_search() ) {
    $page_layout = 0;
  }
?>

<?php if ( $page_layout == '1' ) : ?>
  <div class="qrt-half-banner qrt-left-align<?php if ( ! $page_bg_animation ) : ?> qrt-animated-zoom<?php else : ?> qrt-animated-show<?php endif; ?>">
    <?php if ( $bg_type == 'image' ) : ?>
      <?php if ( $bg_image ) : ?>
      <div class="qrt-image-frame">
        <img src="<?php echo esc_url( $bg_image ); ?>" alt="<?php echo esc_attr( $page_title ); ?>">
      </div>
      <?php endif; ?>
    <?php elseif ( $bg_type == 'map' ) : ?>
      <div class="qrt-map-frame">
        <div class="qrt-lock"><i class="fas fa-lock"></i></div>
        <div id="map" data-long="<?php echo esc_attr( $bg_map_long ); ?>" data-lat="<?php echo esc_attr( $bg_map_lat ); ?>" data-zoom="<?php echo esc_attr( $bg_map_zoom ); ?>" class="qrt-map"></div>
      </div>
    <?php else : ?>
      <?php if ( $bg_video ) : ?>
      <video autoplay loop class="qrt-video-background" poster="<?php echo esc_url( $bg_image ); ?>" muted>
        <source src="<?php echo esc_url( $bg_video ); ?>" type="video/mp4">
      </video>
      <?php endif; ?>
    <?php endif; ?>
      <div class="qrt-overlay">
        <?php if ( ! $page_scroll ) : ?>
        <div class="qrt-scroll-hint">
          <span></span>
        </div>
        <?php endif; ?>
        
        <div class="qrt-banner-title">
          <?php if ( $page_title ) : ?>
          <h2 class="qrt-white qrt-mb-10">
            <?php echo wp_kses_post( $page_title ); ?>
          </h2>
          <?php endif; ?>
          <div class="qrt-divider-2"></div>
          <?php if ( $page_title ) : ?>
          <div class="qrt-text qrt-white qrt-mb-20">
              <?php echo wp_kses_post( $page_description ); ?>
          </div>
          <?php endif; ?>
          <?php if ( $page_button ) : ?>
          <a href="<?php echo esc_url( $page_button_url ); ?>" class="qrt-btn qrt-btn-md qrt-btn-color qrt-anima-link">
              <span><?php echo esc_html( $page_button ); ?></span>
          </a>
          <?php endif; ?>
        </div>
    </div>
  </div>
<?php endif; ?>